/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import org.torqlang.klvm.Flt64Impl;
import org.torqlang.klvm.Num;

public interface Flt64
extends Num {
    public static final Flt64 F64_MAX = Flt64Impl.of(Double.MAX_VALUE);
    public static final Flt64 F64_MIN = Flt64Impl.of(Double.MIN_VALUE);

    public static int fuzzyCompare(double a, double b, double tolerance) {
        if (Flt64.fuzzyEquals(a, b, tolerance)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return Boolean.compare(Double.isNaN(a), Double.isNaN(b));
    }

    public static boolean fuzzyEquals(double a, double b, double tolerance) {
        if (!(tolerance >= 0.0)) {
            throw new IllegalArgumentException("Tolerance must be greater than or equal to zero");
        }
        return Math.copySign(a - b, 1.0) <= tolerance | a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static Flt64 of(double num) {
        return Flt64Impl.of(num);
    }

    public static Flt64 of(String num) {
        return Flt64Impl.of(Double.parseDouble(num));
    }

    default public boolean fuzzyEquals(Flt64 other, Flt64 tolerance) {
        return Flt64.fuzzyEquals(this.doubleValue(), other.doubleValue(), tolerance.doubleValue());
    }

    @Override
    public Flt64 negate();
}

