/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.math.BigDecimal;
import java.util.Set;
import org.torqlang.klvm.Char;
import org.torqlang.klvm.Dec128;
import org.torqlang.klvm.Flt32;
import org.torqlang.klvm.Flt64;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Num;
import org.torqlang.klvm.Value;

final class Flt64Impl
implements Flt64 {
    private final double value;

    private Flt64Impl(double value) {
        this.value = value;
    }

    static Flt64Impl of(double num) {
        return new Flt64Impl(num);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitScalar(this, state);
    }

    @Override
    public final Num add(Value addend) {
        return Num.assertNum(addend).addFrom(this);
    }

    @Override
    public final Dec128 addFrom(Dec128 augend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Flt64 addFrom(Char augend) {
        return Flt64Impl.of((double)augend.intValue() + this.value);
    }

    @Override
    public final Flt64 addFrom(Int32 augend) {
        return Flt64Impl.of((double)augend.intValue() + this.value);
    }

    @Override
    public final Flt64 addFrom(Int64 augend) {
        return Flt64Impl.of((double)augend.longValue() + this.value);
    }

    @Override
    public final Flt64 addFrom(Flt32 augend) {
        return Flt64Impl.of((double)augend.floatValue() + this.value);
    }

    @Override
    public final Flt64 addFrom(Flt64 augend) {
        return Flt64Impl.of(augend.doubleValue() + this.value);
    }

    @Override
    public final String appendToString(String string) {
        return string + this.value;
    }

    @Override
    public final int compareValueFrom(Dec128 left) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final int compareValueFrom(Char left) {
        return Double.compare(left.doubleValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Int32 left) {
        return Double.compare(left.doubleValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Int64 left) {
        return Double.compare(left.doubleValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Flt32 left) {
        return Double.compare(left.doubleValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Flt64 left) {
        return Double.compare(left.doubleValue(), this.value);
    }

    @Override
    public final int compareValueTo(Value right) {
        return Num.assertNum(right).compareValueFrom(this);
    }

    @Override
    public final BigDecimal decimal128Value() {
        return Dec128.bigDecimal128(this.value);
    }

    @Override
    public final Num divide(Value divisor) {
        return Num.assertNum(divisor).divideFrom(this);
    }

    @Override
    public final Dec128 divideFrom(Dec128 dividend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Flt64 divideFrom(Char dividend) {
        return Flt64Impl.of((double)dividend.intValue() / this.value);
    }

    @Override
    public final Flt64 divideFrom(Int32 dividend) {
        return Flt64Impl.of((double)dividend.intValue() / this.value);
    }

    @Override
    public final Flt64 divideFrom(Int64 dividend) {
        return Flt64Impl.of((double)dividend.longValue() / this.value);
    }

    @Override
    public final Flt64 divideFrom(Flt32 dividend) {
        return Flt64Impl.of((double)dividend.floatValue() / this.value);
    }

    @Override
    public final Flt64 divideFrom(Flt64 dividend) {
        return Flt64Impl.of(dividend.doubleValue() / this.value);
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final boolean entails(Value operand, Set<Memo> memos) {
        return this.equals(operand);
    }

    public final boolean equals(Object right) {
        if (!(right instanceof Flt64Impl)) {
            return false;
        }
        Flt64Impl f = (Flt64Impl)right;
        return this.value == f.value;
    }

    @Override
    public final float floatValue() {
        return (float)this.value;
    }

    @Override
    public final String formatAsKernelString() {
        return Double.toString(this.value);
    }

    public final int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final boolean isValidKey() {
        return false;
    }

    @Override
    public final long longValue() {
        return (long)this.value;
    }

    @Override
    public final Num modulo(Value divisor) {
        return Num.assertNum(divisor).moduloFrom(this);
    }

    @Override
    public final Dec128 moduloFrom(Dec128 dividend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Flt64 moduloFrom(Char dividend) {
        return Flt64Impl.of((double)dividend.intValue() % this.value);
    }

    @Override
    public final Flt64 moduloFrom(Int32 dividend) {
        return Flt64Impl.of((double)dividend.intValue() % this.value);
    }

    @Override
    public final Flt64 moduloFrom(Int64 dividend) {
        return Flt64Impl.of((double)dividend.longValue() % this.value);
    }

    @Override
    public final Flt64 moduloFrom(Flt32 dividend) {
        return Flt64Impl.of((double)dividend.floatValue() % this.value);
    }

    @Override
    public final Flt64 moduloFrom(Flt64 dividend) {
        return Flt64Impl.of(dividend.doubleValue() % this.value);
    }

    @Override
    public final Num multiply(Value multiplicand) {
        return Num.assertNum(multiplicand).multiplyFrom(this);
    }

    @Override
    public final Dec128 multiplyFrom(Dec128 multiplicand) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Flt64 multiplyFrom(Char multiplicand) {
        return Flt64Impl.of((double)multiplicand.intValue() * this.value);
    }

    @Override
    public final Flt64 multiplyFrom(Int32 multiplicand) {
        return Flt64Impl.of((double)multiplicand.intValue() * this.value);
    }

    @Override
    public final Flt64 multiplyFrom(Int64 multiplicand) {
        return Flt64Impl.of((double)multiplicand.longValue() * this.value);
    }

    @Override
    public final Flt64 multiplyFrom(Flt32 multiplicand) {
        return Flt64Impl.of((double)multiplicand.floatValue() * this.value);
    }

    @Override
    public final Flt64 multiplyFrom(Flt64 multiplicand) {
        return Flt64Impl.of(multiplicand.doubleValue() * this.value);
    }

    @Override
    public final Flt64 negate() {
        return Flt64Impl.of(-1.0 * this.value);
    }

    @Override
    public final Num subtract(Value subtrahend) {
        return Num.assertNum(subtrahend).subtractFrom(this);
    }

    @Override
    public final Dec128 subtractFrom(Dec128 minuend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Flt64 subtractFrom(Char minuend) {
        return Flt64Impl.of((double)minuend.intValue() - this.value);
    }

    @Override
    public final Flt64 subtractFrom(Int32 minuend) {
        return Flt64Impl.of((double)minuend.intValue() - this.value);
    }

    @Override
    public final Flt64 subtractFrom(Int64 minuend) {
        return Flt64Impl.of((double)minuend.longValue() - this.value);
    }

    @Override
    public final Flt64 subtractFrom(Flt32 minuend) {
        return Flt64Impl.of((double)minuend.floatValue() - this.value);
    }

    @Override
    public final Flt64 subtractFrom(Flt64 minuend) {
        return Flt64Impl.of(minuend.doubleValue() - this.value);
    }

    @Override
    public final Double toNativeValue() {
        return this.value;
    }

    public final String toString() {
        return "" + this.value;
    }
}

