/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.CellMod;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public final class GetCellValueInstr
extends AbstractInstr {
    public final Ident cell;
    public final Ident target;

    public GetCellValueInstr(Ident cell, Ident target, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.cell = cell;
        this.target = target;
    }

    public final CompleteOrIdent a() {
        return this.cell;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitGetCellValueInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.cell, knownBound, lexicallyFree);
        Ident.captureLexicallyFree(this.target, knownBound, lexicallyFree);
    }

    @Override
    public void compute(Env env, Machine machine) throws WaitException {
        CellMod.CellObj cellObj = (CellMod.CellObj)this.cell.resolveValue(env);
        ValueOrVar targetRes = this.target.resolveValueOrVar(env);
        targetRes.bindToValueOrVar(cellObj.get(), null);
    }
}

