/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.FeatureOrIdentPtn;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Ptn;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.ResolvedIdentPtn;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrIdent;
import org.torqlang.klvm.ValueOrResolvedPtn;
import org.torqlang.klvm.WaitException;

public final class IdentPtn
implements Ptn,
FeatureOrIdentPtn {
    public final Ident ident;
    public final boolean escaped;

    public IdentPtn(Ident ident, boolean escaped) {
        this.ident = ident;
        this.escaped = escaped;
    }

    public IdentPtn(Ident ident) {
        this(ident, false);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitIdentPtn(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        if (this.escaped) {
            Ident.captureLexicallyFree(this.ident, knownBound, lexicallyFree);
        } else {
            knownBound.add(this.ident);
        }
    }

    @Override
    public final ValueOrResolvedPtn caseNonRecOfThis(Value nonRecValue, Env env) throws WaitException {
        if (this.escaped) {
            return nonRecValue.entails(this.ident.resolveValue(env), null) ? nonRecValue : null;
        }
        return new ResolvedIdentPtn(this.ident);
    }

    @Override
    public final ValueOrResolvedPtn caseRecOfThis(Rec rec, Env env) throws WaitException {
        if (this.escaped) {
            return rec.entails(this.ident.resolveValue(env), null) ? rec : null;
        }
        return new ResolvedIdentPtn(this.ident);
    }

    @Override
    public final Value resolveValue(Env env) throws WaitException {
        if (!this.escaped) {
            throw new IllegalArgumentException("An unescaped identifier cannot appear as a pattern label or feature");
        }
        return this.ident.resolveValue(env);
    }

    @Override
    public final ValueOrIdent resolveValueOrIdent(Env env) throws WaitException {
        return this.escaped ? this.ident.resolveValue(env) : this.ident;
    }

    public final String toString() {
        return this.toKernelString();
    }
}

