/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.Bool;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.NotBoolError;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public final class IfInstr
extends AbstractInstr {
    public final CompleteOrIdent x;
    public final Instr consequent;

    public IfInstr(CompleteOrIdent x, Instr consequent, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.x = x;
        this.consequent = consequent;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitIfInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.x, knownBound, lexicallyFree);
        this.consequent.captureLexicallyFree(knownBound, lexicallyFree);
    }

    @Override
    public final void compute(Env env, Machine machine) throws WaitException {
        Value xRes = this.x.resolveValue(env);
        if (!(xRes instanceof Bool)) {
            throw new NotBoolError(xRes, this);
        }
        Bool bool = (Bool)xRes;
        if (bool.value) {
            machine.pushStackEntry(this.consequent, env);
        }
    }
}

