/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CommonFeatures;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class Int32Mod
implements KernelModule {
    public static final Str INT32_STR = Str.of("Int32");
    public static final Ident INT32_IDENT = Ident.create(Int32Mod.INT32_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().addField(CommonFeatures.PARSE, Int32Mod::clsParse).build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(INT32_STR, this.namesake).build();

    private Int32Mod() {
    }

    public static Int32Mod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void clsParse(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedCount = 2;
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "Int32.parse");
        }
        Str num = (Str)ys.get(0).resolveValue(env);
        Int32 int32 = Int32.of(Integer.parseInt(num.value));
        ValueOrVar target = ys.get(1).resolveValueOrVar(env);
        target.bindToValue(int32, null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return INT32_IDENT;
    }

    private static final class LazySingleton {
        private static final Int32Mod SINGLETON = new Int32Mod();

        private LazySingleton() {
        }
    }
}

