/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Set;
import org.torqlang.klvm.Char;
import org.torqlang.klvm.Dec128;
import org.torqlang.klvm.Flt32;
import org.torqlang.klvm.Flt32Impl;
import org.torqlang.klvm.Flt64;
import org.torqlang.klvm.Flt64Impl;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Num;
import org.torqlang.klvm.Value;

final class Int64Impl
implements Int64 {
    private static final int I64_CACHE_SIZE = 10;
    private static final Int64Impl[] I64_CACHE = new Int64Impl[10];
    public final long value;

    private Int64Impl(long value) {
        this.value = value;
    }

    static Int64Impl of(long num) {
        if (num > -1L && num < 10L) {
            return I64_CACHE[(int)num];
        }
        return new Int64Impl(num);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitScalar(this, state);
    }

    @Override
    public final Num add(Value addend) {
        return Num.assertNum(addend).addFrom(this);
    }

    @Override
    public final Dec128 addFrom(Dec128 augend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Int64 addFrom(Char augend) {
        return Int64Impl.of(augend.longValue() + this.value);
    }

    @Override
    public final Int64 addFrom(Int32 augend) {
        return Int64Impl.of(augend.longValue() + this.value);
    }

    @Override
    public final Int64 addFrom(Int64 augend) {
        return Int64Impl.of(augend.longValue() + this.value);
    }

    @Override
    public final Flt32 addFrom(Flt32 augend) {
        return Flt32Impl.of(augend.floatValue() + (float)this.value);
    }

    @Override
    public final Flt64 addFrom(Flt64 augend) {
        return Flt64Impl.of(augend.doubleValue() + (double)this.value);
    }

    @Override
    public final String appendToString(String string) {
        return string + this.value;
    }

    @Override
    public final int compareValueFrom(Dec128 left) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final int compareValueFrom(Char left) {
        return Long.compare(left.longValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Int32 left) {
        return Long.compare(left.longValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Int64 left) {
        return Long.compare(left.longValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Flt32 left) {
        return Float.compare(left.floatValue(), this.value);
    }

    @Override
    public final int compareValueFrom(Flt64 left) {
        return Double.compare(left.doubleValue(), this.value);
    }

    @Override
    public final int compareValueTo(Value right) {
        return Num.assertNum(right).compareValueFrom(this);
    }

    @Override
    public final BigDecimal decimal128Value() {
        return new BigDecimal(this.value, MathContext.DECIMAL128);
    }

    @Override
    public final Num divide(Value divisor) {
        return Num.assertNum(divisor).divideFrom(this);
    }

    @Override
    public final Dec128 divideFrom(Dec128 dividend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Int64 divideFrom(Char dividend) {
        return Int64Impl.of((long)dividend.intValue() / this.value);
    }

    @Override
    public final Int64 divideFrom(Int32 dividend) {
        return Int64Impl.of((long)dividend.intValue() / this.value);
    }

    @Override
    public final Int64 divideFrom(Int64 dividend) {
        return Int64Impl.of(dividend.longValue() / this.value);
    }

    @Override
    public final Flt32 divideFrom(Flt32 dividend) {
        return Flt32Impl.of(dividend.floatValue() / (float)this.value);
    }

    @Override
    public final Flt64 divideFrom(Flt64 dividend) {
        return Flt64Impl.of(dividend.doubleValue() / (double)this.value);
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final boolean entails(Value operand, Set<Memo> memos) {
        return this.equals(operand);
    }

    public final boolean equals(Object right) {
        if (!(right instanceof Int64Impl)) {
            return false;
        }
        Int64Impl i = (Int64Impl)right;
        return this.value == i.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final String formatAsKernelString() {
        return this.value + "L";
    }

    public final int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final boolean isValidKey() {
        return true;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final Num modulo(Value divisor) {
        return Num.assertNum(divisor).moduloFrom(this);
    }

    @Override
    public final Dec128 moduloFrom(Dec128 dividend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Int64 moduloFrom(Char dividend) {
        return Int64Impl.of((long)dividend.intValue() % this.value);
    }

    @Override
    public final Int64 moduloFrom(Int32 dividend) {
        return Int64Impl.of((long)dividend.intValue() % this.value);
    }

    @Override
    public final Int64 moduloFrom(Int64 dividend) {
        return Int64Impl.of(dividend.longValue() % this.value);
    }

    @Override
    public final Flt32 moduloFrom(Flt32 dividend) {
        return Flt32Impl.of(dividend.floatValue() % (float)this.value);
    }

    @Override
    public final Flt64 moduloFrom(Flt64 dividend) {
        return Flt64Impl.of(dividend.doubleValue() % (double)this.value);
    }

    @Override
    public final Num multiply(Value multiplicand) {
        return Num.assertNum(multiplicand).multiplyFrom(this);
    }

    @Override
    public final Dec128 multiplyFrom(Dec128 multiplicand) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Int64 multiplyFrom(Char multiplicand) {
        return Int64Impl.of(multiplicand.longValue() * this.value);
    }

    @Override
    public final Int64 multiplyFrom(Int32 multiplicand) {
        return Int64Impl.of(multiplicand.longValue() * this.value);
    }

    @Override
    public final Int64 multiplyFrom(Int64 multiplicand) {
        return Int64Impl.of(multiplicand.longValue() * this.value);
    }

    @Override
    public final Flt32 multiplyFrom(Flt32 multiplicand) {
        return Flt32Impl.of(multiplicand.floatValue() * (float)this.value);
    }

    @Override
    public final Flt64 multiplyFrom(Flt64 multiplicand) {
        return Flt64Impl.of(multiplicand.doubleValue() * (double)this.value);
    }

    @Override
    public final Int64 negate() {
        return Int64Impl.of(-1L * this.value);
    }

    @Override
    public final Num subtract(Value subtrahend) {
        return Num.assertNum(subtrahend).subtractFrom(this);
    }

    @Override
    public final Dec128 subtractFrom(Dec128 minuend) {
        throw new IllegalArgumentException("Not a Dec128");
    }

    @Override
    public final Int64 subtractFrom(Char minuend) {
        return Int64Impl.of(minuend.longValue() - this.value);
    }

    @Override
    public final Int64 subtractFrom(Int32 minuend) {
        return Int64Impl.of(minuend.longValue() - this.value);
    }

    @Override
    public final Int64 subtractFrom(Int64 minuend) {
        return Int64Impl.of(minuend.longValue() - this.value);
    }

    @Override
    public final Flt32 subtractFrom(Flt32 minuend) {
        return Flt32Impl.of(minuend.floatValue() - (float)this.value);
    }

    @Override
    public final Flt64 subtractFrom(Flt64 minuend) {
        return Flt64Impl.of(minuend.doubleValue() - (double)this.value);
    }

    @Override
    public final Long toNativeValue() {
        return this.value;
    }

    public final String toString() {
        return "" + this.value;
    }

    static {
        for (int i = 0; i < 10; ++i) {
            Int64Impl.I64_CACHE[i] = new Int64Impl(i);
        }
    }
}

