/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CommonFeatures;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class Int64Mod
implements KernelModule {
    public static final Str INT64_STR = Str.of("Int64");
    public static final Ident INT64_IDENT = Ident.create(Int64Mod.INT64_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().addField(CommonFeatures.PARSE, Int64Mod::clsParse).build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(INT64_STR, this.namesake).build();

    private Int64Mod() {
    }

    public static Int64Mod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void clsParse(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedCount = 2;
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "Int64.parse");
        }
        Str num = (Str)ys.get(0).resolveValue(env);
        Int64 int64 = Int64.of(Long.parseLong(num.value));
        ValueOrVar target = ys.get(1).resolveValueOrVar(env);
        target.bindToValue(int64, null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return INT64_IDENT;
    }

    private static final class LazySingleton {
        private static final Int64Mod SINGLETON = new Int64Mod();

        private LazySingleton() {
        }
    }
}

