/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import org.torqlang.klvm.ActInstr;
import org.torqlang.klvm.ActorCfg;
import org.torqlang.klvm.ActorCtor;
import org.torqlang.klvm.AddInstr;
import org.torqlang.klvm.ApplyInstr;
import org.torqlang.klvm.BindCompleteToCompleteInstr;
import org.torqlang.klvm.BindCompleteToIdentInstr;
import org.torqlang.klvm.BindCompleteToValueOrVarInstr;
import org.torqlang.klvm.BindIdentToIdentInstr;
import org.torqlang.klvm.CaseElseInstr;
import org.torqlang.klvm.CaseInstr;
import org.torqlang.klvm.CatchInstr;
import org.torqlang.klvm.Closure;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CreateActorCtorInstr;
import org.torqlang.klvm.CreateProcInstr;
import org.torqlang.klvm.CreateRecInstr;
import org.torqlang.klvm.CreateTupleInstr;
import org.torqlang.klvm.DebugInstr;
import org.torqlang.klvm.DisentailsInstr;
import org.torqlang.klvm.DivideInstr;
import org.torqlang.klvm.EntailsInstr;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.FailedValue;
import org.torqlang.klvm.FeatureOrIdent;
import org.torqlang.klvm.FieldDef;
import org.torqlang.klvm.FieldPtn;
import org.torqlang.klvm.GetCellValueInstr;
import org.torqlang.klvm.GreaterThanInstr;
import org.torqlang.klvm.GreaterThanOrEqualToInstr;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.IdentDef;
import org.torqlang.klvm.IdentPtn;
import org.torqlang.klvm.IfElseInstr;
import org.torqlang.klvm.IfInstr;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.JumpCatchInstr;
import org.torqlang.klvm.JumpThrowInstr;
import org.torqlang.klvm.Kernel;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.LessThanInstr;
import org.torqlang.klvm.LessThanOrEqualToInstr;
import org.torqlang.klvm.LocalInstr;
import org.torqlang.klvm.ModuloInstr;
import org.torqlang.klvm.MultiplyInstr;
import org.torqlang.klvm.NegateInstr;
import org.torqlang.klvm.NotInstr;
import org.torqlang.klvm.Null;
import org.torqlang.klvm.Obj;
import org.torqlang.klvm.OpaqueValue;
import org.torqlang.klvm.Proc;
import org.torqlang.klvm.ProcDef;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.RecDef;
import org.torqlang.klvm.RecPtn;
import org.torqlang.klvm.ResolvedFieldPtn;
import org.torqlang.klvm.ResolvedIdentPtn;
import org.torqlang.klvm.ResolvedRecPtn;
import org.torqlang.klvm.Scalar;
import org.torqlang.klvm.SelectAndApplyInstr;
import org.torqlang.klvm.SelectInstr;
import org.torqlang.klvm.SeqInstr;
import org.torqlang.klvm.SetCellValueInstr;
import org.torqlang.klvm.SkipInstr;
import org.torqlang.klvm.Stack;
import org.torqlang.klvm.SubtractInstr;
import org.torqlang.klvm.ThrowInstr;
import org.torqlang.klvm.TryInstr;
import org.torqlang.klvm.Tuple;
import org.torqlang.klvm.TupleDef;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueDef;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.VarSet;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.FormatterState;
import org.torqlang.util.NeedsImpl;

public final class KernelFormatter
implements KernelVisitor<FormatterState, Void> {
    public static final KernelFormatter DEFAULT = new KernelFormatter();
    private static final String $ADD = "$add";
    private static final String $BIND = "$bind";
    private static final String $CREATE_ACTOR_CTOR = "$create_actor_ctor";
    private static final String $CREATE_PROC = "$create_proc";
    private static final String $CREATE_REC = "$create_rec";
    private static final String $CREATE_TUPLE = "$create_tuple";
    private static final String $DIV = "$div";
    private static final String $EQ = "$eq";
    private static final String $GE = "$ge";
    private static final String $GET = "$get";
    private static final String $GT = "$gt";
    private static final String $JUMP_CATCH = "$jump_catch";
    private static final String $JUMP_THROW = "$jump_throw";
    private static final String $LE = "$le";
    private static final String $LT = "$lt";
    private static final String $MOD = "$mod";
    private static final String $MULT = "$mult";
    private static final String $NE = "$ne";
    private static final String $NEGATE = "$negate";
    private static final String $NOT = "$not";
    private static final String $SET = "$set";
    private static final String $SUB = "$sub";
    private static final String $SELECT = "$select";
    private static final String $SELECT_APPLY = "$select_apply";
    private final int maxLevel;

    public KernelFormatter() {
        this(Integer.MAX_VALUE);
    }

    public KernelFormatter(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    private void accept(Kernel kernel, FormatterState state) {
        if (state.level() != -1 && state.level() > this.maxLevel) {
            state.write("<<omitted>>");
        } else {
            kernel.accept(this, state);
        }
    }

    public final String format(Kernel kernel) {
        String string;
        StringWriter sw = new StringWriter();
        try {
            FormatterState state = new FormatterState((Writer)sw);
            this.accept(kernel, state);
            state.flush();
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        sw.close();
        return string;
    }

    private void formatApplyArgs(List<CompleteOrIdent> args, FormatterState state) {
        state.write('(');
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                state.write(',');
                state.write(' ');
            }
            CompleteOrIdent y = args.get(i);
            this.accept(y, state.inline());
        }
        state.write(')');
    }

    private void formatBinaryInstr(String oper, CompleteOrIdent a, CompleteOrIdent b, Ident x, FormatterState state) {
        state.write(oper);
        state.write('(');
        this.accept(a, state.inline());
        state.write(", ");
        this.accept(b, state.inline());
        state.write(", ");
        this.accept(x, state.inline());
        state.write(')');
    }

    private void formatBindInstr(Kernel a, Kernel x, FormatterState state) {
        state.write($BIND);
        state.write('(');
        this.accept(a, state.inline());
        state.write(", ");
        this.accept(x, state.inline());
        state.write(')');
    }

    @Override
    public final Void visitActInstr(ActInstr instr, FormatterState state) {
        state.write("$act");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.instr, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public final Void visitActorCfg(ActorCfg value, FormatterState state) {
        state.write("// ActorCfg:");
        state.writeNewLineAndIndent();
        List<Complete> args = value.args();
        if (args.isEmpty()) {
            state.write("// args.size() == 0");
            state.writeNewLineAndIndent();
        }
        for (int i = 0; i < args.size(); ++i) {
            Complete arg = args.get(i);
            state.write("// arg[");
            state.write(Integer.toString(i));
            state.write("]: ");
            this.accept(arg, state.inline());
            state.writeNewLineAndIndent();
        }
        this.accept(value.handlersCtor(), state);
        return null;
    }

    @Override
    public final Void visitActorCtor(ActorCtor value, FormatterState state) {
        return this.visitClosure(value.handlersCtor(), state);
    }

    @Override
    public final Void visitAddInstr(AddInstr instr, FormatterState state) {
        this.formatBinaryInstr($ADD, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitApplyInstr(ApplyInstr instr, FormatterState state) {
        this.accept(instr.x, state.inline());
        this.formatApplyArgs(instr.ys, state);
        return null;
    }

    @Override
    public final Void visitBindCompleteToCompleteInstr(BindCompleteToCompleteInstr instr, FormatterState state) {
        this.formatBindInstr(instr.a, instr.x, state);
        return null;
    }

    @Override
    public final Void visitBindCompleteToIdentInstr(BindCompleteToIdentInstr instr, FormatterState state) {
        this.formatBindInstr(instr.a, instr.x, state);
        return null;
    }

    @Override
    public final Void visitBindCompleteToValueOrVarInstr(BindCompleteToValueOrVarInstr instr, FormatterState state) {
        this.formatBindInstr(instr.a, instr.x, state);
        return null;
    }

    @Override
    public final Void visitBindIdentToIdentInstr(BindIdentToIdentInstr instr, FormatterState state) {
        this.formatBindInstr(instr.a, instr.x, state);
        return null;
    }

    @Override
    public final Void visitCaseElseInstr(CaseElseInstr instr, FormatterState state) {
        state.write("case ");
        this.accept(instr.x, state.inline());
        state.write(" of ");
        this.accept(instr.valueOrPtn, state.inline());
        state.write(" then");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.consequent, nextLevelState);
        state.writeAfterNewLineAndIdent("else");
        nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.alternate, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public final Void visitCaseInstr(CaseInstr instr, FormatterState state) {
        state.write("case ");
        this.accept(instr.x, state.inline());
        state.write(" of ");
        this.accept(instr.valueOrPtn, state.inline());
        state.write(" then");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.consequent, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public final Void visitCatchInstr(CatchInstr instr, FormatterState state) {
        state.write("catch ");
        this.accept(instr.arg, state.inline());
        state.write(" in");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.caseInstr, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public final Void visitClosure(Closure value, FormatterState state) {
        if (value.capturedEnv().shallowSize() > 0) {
            this.visitEnv(value.capturedEnv(), state);
            state.writeNewLineAndIndent();
        }
        this.visitProcDef(value.procDef(), state);
        return null;
    }

    @Override
    public final Void visitCreateActorCtorInstr(CreateActorCtorInstr instr, FormatterState state) {
        state.write($CREATE_ACTOR_CTOR);
        state.write('(');
        this.visitProcDef(instr.procDef, state);
        state.write(", ");
        this.accept(instr.x, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitCreateProcInstr(CreateProcInstr instr, FormatterState state) {
        state.write($CREATE_PROC);
        state.write('(');
        this.visitProcDef(instr.procDef, state);
        state.write(", ");
        this.accept(instr.x, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitCreateRecInstr(CreateRecInstr instr, FormatterState state) {
        state.write($CREATE_REC);
        state.write('(');
        this.accept(instr.recDef, state.inline());
        state.write(", ");
        this.accept(instr.x, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitCreateTupleInstr(CreateTupleInstr instr, FormatterState state) {
        state.write($CREATE_TUPLE);
        state.write('(');
        this.accept(instr.tupleDef, state.inline());
        state.write(", ");
        this.accept(instr.x, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitDebugInstr(DebugInstr instr, FormatterState state) {
        this.accept(instr.nextInstr(), state);
        return null;
    }

    @Override
    public final Void visitDisentailsInstr(DisentailsInstr instr, FormatterState state) {
        this.formatBinaryInstr($NE, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitDivideInstr(DivideInstr instr, FormatterState state) {
        this.formatBinaryInstr($DIV, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitEntailsInstr(EntailsInstr instr, FormatterState state) {
        this.formatBinaryInstr($EQ, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public Void visitEnv(Env env, FormatterState state) {
        String envFormatted = env.formatValue();
        if (!envFormatted.isBlank()) {
            String[] lines = envFormatted.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                state.write("// ");
                state.write(lines[i]);
                if (i + 1 >= lines.length) continue;
                state.writeNewLineAndIndent();
            }
        }
        return null;
    }

    @Override
    public final Void visitFailedValue(FailedValue kernel, FormatterState state) {
        state.write("FailedValue(error=");
        if (kernel.error() == null) {
            state.write("null");
        } else {
            this.accept(kernel.error(), state.inline());
        }
        state.write(')');
        return null;
    }

    @Override
    public Void visitFieldDef(FieldDef kernel, FormatterState state) {
        this.accept(kernel.feature, state.inline());
        state.write(": ");
        this.accept(kernel.value, state.inline());
        return null;
    }

    @Override
    public Void visitFieldPtn(FieldPtn kernel, FormatterState state) {
        this.accept(kernel.feature, state.inline());
        state.write(": ");
        this.accept(kernel.value, state.inline());
        return null;
    }

    @Override
    public final Void visitGetCellValueInstr(GetCellValueInstr instr, FormatterState state) {
        state.write($GET);
        state.write('(');
        this.accept(instr.cell, state.inline());
        state.write(", ");
        this.accept(instr.target, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitGreaterThanOrEqualToInstr(GreaterThanOrEqualToInstr instr, FormatterState state) {
        this.formatBinaryInstr($GE, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitGreaterThanInstr(GreaterThanInstr instr, FormatterState state) {
        this.formatBinaryInstr($GT, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitIdent(Ident kernel, FormatterState state) {
        if (Ident.isSimpleName(kernel.name)) {
            state.write(kernel.name);
        } else {
            state.write(Ident.quote(kernel.name));
        }
        return null;
    }

    @Override
    public final Void visitIdentDef(IdentDef kernel, FormatterState state) {
        this.accept(kernel.ident, state.inline());
        if (kernel.value != null) {
            state.write(" = ");
            this.accept(kernel.value, state.inline());
        }
        return null;
    }

    @Override
    public Void visitIdentPtn(IdentPtn kernel, FormatterState state) {
        if (kernel.escaped) {
            state.write('~');
        }
        this.accept(kernel.ident, state.inline());
        return null;
    }

    @Override
    public final Void visitIfElseInstr(IfElseInstr instr, FormatterState state) {
        state.write("if ");
        this.accept(instr.x, state.inline());
        state.write(" then");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.consequent, nextLevelState);
        state.writeAfterNewLineAndIdent("else");
        nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.alternate, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public final Void visitIfInstr(IfInstr instr, FormatterState state) {
        state.write("if ");
        this.accept(instr.x, state.inline());
        state.write(" then");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.consequent, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public Void visitJumpCatchInstr(JumpCatchInstr kernel, FormatterState state) {
        state.write($JUMP_CATCH);
        state.write('(');
        state.write("" + kernel.id);
        state.write(')');
        return null;
    }

    @Override
    public Void visitJumpThrowInstr(JumpThrowInstr kernel, FormatterState state) {
        state.write($JUMP_THROW);
        state.write('(');
        state.write("" + kernel.id);
        state.write(')');
        return null;
    }

    @Override
    public final Void visitLessThanOrEqualToInstr(LessThanOrEqualToInstr instr, FormatterState state) {
        this.formatBinaryInstr($LE, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitLessThanInstr(LessThanInstr instr, FormatterState state) {
        this.formatBinaryInstr($LT, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitLocalInstr(LocalInstr instr, FormatterState state) {
        state.write("local ");
        for (int i = 0; i < instr.xs.size(); ++i) {
            if (i > 0) {
                state.write(',');
                state.write(' ');
            }
            IdentDef id = instr.xs.get(i);
            this.accept(id.ident, state.inline());
            if (id.value == null) continue;
            state.write(" = ");
            this.accept(id.value, state.inline());
        }
        state.write(" in");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.body, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public final Void visitModuloInstr(ModuloInstr instr, FormatterState state) {
        this.formatBinaryInstr($MOD, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitMultiplyInstr(MultiplyInstr instr, FormatterState state) {
        this.formatBinaryInstr($MULT, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitNegateInstr(NegateInstr instr, FormatterState state) {
        state.write($NEGATE);
        state.write('(');
        this.accept(instr.a, state.inline());
        state.write(", ");
        this.accept(instr.x, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitNotInstr(NotInstr instr, FormatterState state) {
        state.write($NOT);
        this.accept(instr.a, state.inline());
        state.write(", ");
        this.accept(instr.x, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitObj(Obj kernel, FormatterState state) {
        state.write(kernel.formatAsKernelString());
        return null;
    }

    @Override
    public final Void visitOpaqueValue(OpaqueValue kernel, FormatterState state) {
        state.write(kernel.getClass().getName());
        return null;
    }

    @Override
    public final Void visitProc(Proc kernel, FormatterState state) {
        state.write(kernel.getClass().getName());
        return null;
    }

    @Override
    public final Void visitProcDef(ProcDef kernel, FormatterState state) {
        state.write("proc (");
        for (int i = 0; i < kernel.xs.size(); ++i) {
            if (i > 0) {
                state.write(',');
                state.write(' ');
            }
            this.accept(kernel.xs.get(i), state.inline());
        }
        state.write(") in");
        ArrayList<Ident> freeIdents = new ArrayList<Ident>(kernel.freeIdents);
        freeIdents.sort(Comparator.comparing(a -> a.name));
        Iterator freeIdentsIter = freeIdents.iterator();
        if (freeIdentsIter.hasNext()) {
            state.write(" // free vars: ");
        }
        while (freeIdentsIter.hasNext()) {
            Ident ident = (Ident)freeIdentsIter.next();
            this.accept(ident, state.inline());
            if (!freeIdentsIter.hasNext()) continue;
            state.write(", ");
        }
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(kernel.instr, nextLevelState);
        state.writeAfterNewLineAndIdent("end");
        return null;
    }

    @Override
    public Void visitRec(Rec kernel, FormatterState state) {
        if (kernel instanceof Tuple) {
            Tuple tuple = (Tuple)kernel;
            this.visitTuple(tuple, null, state);
        } else {
            this.visitRec(kernel, null, state);
        }
        return null;
    }

    private void visitRec(Rec kernel, IdentityHashMap<Rec, Object> memos, FormatterState state) {
        if (memos == null) {
            memos = new IdentityHashMap();
        }
        memos.put(kernel, Value.PRESENT);
        if (kernel.label() == Null.SINGLETON) {
            state.write('{');
        } else {
            this.accept(kernel.label(), state.inline());
            state.write("#{");
        }
        Collection<Var> undeterminedVars = kernel.sweepUndeterminedVars();
        if (!undeterminedVars.isEmpty()) {
            for (Var v : undeterminedVars) {
                state.write(v.formatValue());
            }
        } else {
            for (int i = 0; i < kernel.fieldCount(); ++i) {
                if (i > 0) {
                    state.write(", ");
                }
                this.accept(kernel.featureAt(i), state.inline());
                state.write(": ");
                this.visitRecValue(kernel.valueAt(i).resolveValueOrVar(), memos, state);
            }
        }
        state.write('}');
    }

    @Override
    public Void visitRecDef(RecDef kernel, FormatterState state) {
        if (kernel.label.equals(Rec.DEFAULT_LABEL)) {
            state.write('{');
        } else {
            this.accept(kernel.label, state.inline());
            state.write("#{");
        }
        for (int i = 0; i < kernel.fieldCount(); ++i) {
            if (i > 0) {
                state.write(", ");
            }
            FieldDef fd = kernel.fieldDefAtIndex(i);
            this.accept(fd, state.inline());
        }
        state.write('}');
        return null;
    }

    @Override
    public final Void visitRecPtn(RecPtn kernel, FormatterState state) {
        if (kernel.label().equals(Rec.DEFAULT_LABEL)) {
            state.write('{');
        } else {
            this.accept(kernel.label(), state.inline());
            state.write("#{");
        }
        for (int i = 0; i < kernel.fieldCount(); ++i) {
            if (i > 0) {
                state.write(", ");
            }
            FieldPtn fp = kernel.fields().get(i);
            this.accept(fp, state.inline());
            if (i + 1 != kernel.fieldCount() || !kernel.partialArity()) continue;
            state.write(", ...");
        }
        state.write('}');
        return null;
    }

    private void visitRecValue(ValueOrVar value, IdentityHashMap<Rec, Object> memos, FormatterState state) {
        if (value instanceof Rec) {
            Rec recValue = (Rec)value;
            if (memos.containsKey(recValue)) {
                state.write("<<$circular " + Kernel.toSystemString(recValue) + ">>");
            } else if (recValue instanceof Tuple) {
                Tuple tupleValue = (Tuple)recValue;
                this.visitTuple(tupleValue, memos, state.inline());
            } else {
                this.visitRec(recValue, memos, state.inline());
            }
        } else {
            this.accept(value, state.inline());
        }
    }

    @Override
    public Void visitResolvedFieldPtn(ResolvedFieldPtn kernel, FormatterState state) {
        this.accept(kernel.feature, state.inline());
        state.write(": ");
        this.accept(kernel.value, state.inline());
        return null;
    }

    @Override
    public final Void visitResolvedIdentPtn(ResolvedIdentPtn kernel, FormatterState state) {
        this.accept(kernel.ident, state.inline());
        return null;
    }

    @Override
    public final Void visitResolvedRecPtn(ResolvedRecPtn kernel, FormatterState state) {
        this.accept(kernel.label, state.inline());
        state.write("#{");
        for (int i = 0; i < kernel.fieldCount(); ++i) {
            if (i > 0) {
                state.write(", ");
            }
            ResolvedFieldPtn fp = kernel.fields.get(i);
            this.accept(fp, state.inline());
            if (i + 1 != kernel.fieldCount() || !kernel.partialArity) continue;
            state.write(", ...");
        }
        state.write('}');
        return null;
    }

    @Override
    public final Void visitScalar(Scalar kernel, FormatterState state) {
        state.write(kernel.formatAsKernelString());
        return null;
    }

    @Override
    public final Void visitSelectAndApplyInstr(SelectAndApplyInstr instr, FormatterState state) {
        int i;
        state.write($SELECT_APPLY);
        state.write('(');
        this.accept(instr.rec, state.inline());
        state.write(", [");
        for (i = 0; i < instr.path.size(); ++i) {
            if (i > 0) {
                state.write(", ");
            }
            FeatureOrIdent f = instr.path.get(i);
            this.accept(f, state.inline());
        }
        state.write(']');
        if (!instr.args.isEmpty()) {
            state.write(", ");
            for (i = 0; i < instr.args.size(); ++i) {
                if (i > 0) {
                    state.write(',');
                    state.write(' ');
                }
                CompleteOrIdent y = instr.args.get(i);
                this.accept(y, state.inline());
            }
        }
        state.write(')');
        return null;
    }

    @Override
    public final Void visitSelectInstr(SelectInstr instr, FormatterState state) {
        state.write($SELECT);
        state.write('(');
        this.accept(instr.rec, state.inline());
        state.write(", ");
        this.accept(instr.feature, state.inline());
        state.write(", ");
        this.accept(instr.target, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitSeqInstr(SeqInstr instr, FormatterState state) {
        List<Instr> list = instr.list;
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                state.writeNewLineAndIndent();
            }
            this.accept(list.get(i), state);
        }
        return null;
    }

    @Override
    public final Void visitSetCellValueInstr(SetCellValueInstr instr, FormatterState state) {
        state.write($SET);
        state.write('(');
        this.accept(instr.cell, state.inline());
        state.write(", ");
        this.accept(instr.value, state.inline());
        state.write(')');
        return null;
    }

    @Override
    public final Void visitSkipInstr(SkipInstr instr, FormatterState state) {
        state.write("skip");
        return null;
    }

    @Override
    public Void visitStack(Stack kernel, FormatterState state) {
        Stack s = kernel;
        while (s != null) {
            state.write(Kernel.toSystemString(s.instr));
            if (s.next != null) {
                state.writeNewLineAndIndent();
            }
            s = s.next;
        }
        return null;
    }

    @Override
    public final Void visitSubtractInstr(SubtractInstr instr, FormatterState state) {
        this.formatBinaryInstr($SUB, instr.a, instr.b, instr.x, state);
        return null;
    }

    @Override
    public final Void visitThrowInstr(ThrowInstr instr, FormatterState state) {
        state.write("throw ");
        this.accept(instr.error, state.inline());
        return null;
    }

    @Override
    public final Void visitTryInstr(TryInstr instr, FormatterState state) {
        state.write("try");
        FormatterState nextLevelState = state.nextLevel();
        nextLevelState.writeNewLineAndIndent();
        this.accept(instr.body, nextLevelState);
        state.writeNewLineAndIndent();
        this.accept(instr.catchInstr, state);
        return null;
    }

    private void visitTuple(Tuple tuple, IdentityHashMap<Rec, Object> memos, FormatterState state) {
        if (memos == null) {
            memos = new IdentityHashMap();
        }
        memos.put(tuple, Value.PRESENT);
        if (tuple.label() == Null.SINGLETON) {
            state.write('[');
        } else {
            this.accept(tuple.label(), state.inline());
            state.write("#[");
        }
        try {
            tuple.checkDetermined();
        }
        catch (WaitException exc) {
            throw new RuntimeException("Cannot format partial values", exc);
        }
        for (int i = 0; i < tuple.fieldCount(); ++i) {
            if (i > 0) {
                state.write(", ");
            }
            this.visitRecValue(tuple.valueAt(i).resolveValueOrVar(), memos, state);
        }
        state.write(']');
    }

    @Override
    public Void visitTupleDef(TupleDef kernel, FormatterState state) {
        if (kernel.label.equals(Rec.DEFAULT_LABEL)) {
            state.write('[');
        } else {
            this.accept(kernel.label, state.inline());
            state.write("#[");
        }
        for (int i = 0; i < kernel.valueCount(); ++i) {
            if (i > 0) {
                state.write(", ");
            }
            ValueDef vd = kernel.valueDefAtIndex(i);
            this.accept(vd.value, state.inline());
        }
        state.write(']');
        return null;
    }

    @Override
    public final Void visitValueDef(ValueDef kernel, FormatterState state) {
        throw new NeedsImpl();
    }

    @Override
    public final Void visitVar(Var var, FormatterState state) {
        state.write(var.formatValue());
        return null;
    }

    @Override
    public final Void visitVarSet(VarSet varSet, FormatterState state) {
        state.write(varSet.formatValue());
        return null;
    }
}

