/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.Bool;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteProc;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.NotBoundError;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitException;

public class KernelProcs {
    public static final Ident ASSERT_BOUND_IDENT = Ident.create("assert_bound");
    public static final Ident IS_BOUND_IDENT = Ident.create("is_bound");
    public static final Ident IS_DET_IDENT = Ident.create("is_det");
    private static final int ASSERT_BOUND_ARG_COUNT = 1;
    public static final CompleteProc ASSERT_BOUND_PROC = KernelProcs::assertBound;
    private static final int IS_BOUND_ARG_COUNT = 2;
    public static final CompleteProc IS_BOUND_PROC = KernelProcs::isBound;
    private static final int IS_DET_ARG_COUNT = 2;
    public static final CompleteProc IS_DET_PROC = KernelProcs::isDet;

    static void assertBound(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        if (ys.size() != 1) {
            throw new InvalidArgCountError(1, ys, "assert_bound");
        }
        CompleteOrIdent y = ys.get(0);
        ValueOrVar yRes = y.resolveValueOrVar(env);
        if (yRes instanceof Var) {
            Var yVar = (Var)yRes;
            throw new NotBoundError(yVar, machine.current().instr);
        }
    }

    static void isBound(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "is_bound");
        }
        Bool bound = ys.get(0).resolveValueOrVar(env) instanceof Value ? Bool.TRUE : Bool.FALSE;
        ys.get(1).resolveValueOrVar(env).bindToValue(bound, null);
    }

    static void isDet(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        Rec rec;
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "is_det");
        }
        CompleteOrIdent y0 = ys.get(0);
        ValueOrVar valueOrVar = y0.resolveValueOrVar(env);
        Bool det = valueOrVar instanceof Value ? (valueOrVar instanceof Rec ? ((rec = (Rec)valueOrVar).sweepUndeterminedVars().isEmpty() ? Bool.TRUE : Bool.FALSE) : Bool.TRUE) : Bool.FALSE;
        CompleteOrIdent y1 = ys.get(1);
        y1.resolveValueOrVar(env).bindToValue(det, null);
    }
}

