/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.DuplicateIdentError;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.EnvEntry;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.IdentDef;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Var;
import org.torqlang.util.ListTools;
import org.torqlang.util.SourceSpan;

public final class LocalInstr
extends AbstractInstr {
    public final List<IdentDef> xs;
    public final Instr body;

    public LocalInstr(List<IdentDef> xs, Instr body, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.xs = ListTools.nullSafeCopyOf(xs);
        this.body = body;
        this.validate();
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitLocalInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        for (IdentDef idef : this.xs) {
            idef.captureLexicallyFree(knownBound, lexicallyFree);
        }
        this.body.captureLexicallyFree(knownBound, lexicallyFree);
    }

    @Override
    public void compute(Env env, Machine machine) {
        EnvEntry[] localBindings = new EnvEntry[this.xs.size()];
        int index = 0;
        for (IdentDef id : this.xs) {
            Var var = id.value != null ? new Var(id.value) : new Var();
            localBindings[index++] = new EnvEntry(id.ident, var);
        }
        Env bodyEnv = Env.createPrivatelyForKlvm(env, localBindings);
        this.body.pushStackEntries(machine, bodyEnv);
    }

    private void validate() {
        for (int i = 0; i < this.xs.size(); ++i) {
            for (int j = i + 1; j < this.xs.size(); ++j) {
                if (!this.xs.get(i).equals(this.xs.get(j))) continue;
                throw new DuplicateIdentError(this.xs.get((int)i).ident);
            }
        }
    }
}

