/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CatchInstr;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.ComputeAdvice;
import org.torqlang.klvm.ComputeEnd;
import org.torqlang.klvm.ComputeHalt;
import org.torqlang.klvm.ComputePreempt;
import org.torqlang.klvm.ComputeWait;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.EnvEntry;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.JumpCatchInstr;
import org.torqlang.klvm.JumpThrowInstr;
import org.torqlang.klvm.MachineError;
import org.torqlang.klvm.MachineHaltError;
import org.torqlang.klvm.NativeError;
import org.torqlang.klvm.NativeThrow;
import org.torqlang.klvm.Stack;
import org.torqlang.klvm.ThrowInstr;
import org.torqlang.klvm.UncaughtThrowError;
import org.torqlang.klvm.UnmatchedJumpThrowError;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitException;

public final class Machine {
    private final Object owner;
    private Stack stack;
    private Stack current;
    private long computeCount;

    public Machine(Object owner, Stack stack) {
        this(owner, stack, 0L);
    }

    public Machine(Object owner, Stack stack, long computeCount) {
        this.owner = owner;
        this.stack = stack;
        this.computeCount = computeCount;
    }

    public static void compute(Object owner, Stack stack, long timeSlice) {
        Machine machine = new Machine(owner, stack);
        ComputeAdvice advice = machine.compute(timeSlice);
        while (advice == ComputePreempt.SINGLETON) {
            advice = machine.compute(timeSlice);
        }
        if (advice.isWait()) {
            throw new IllegalStateException("Machine is waiting on a variable");
        }
        if (advice.isHalt()) {
            throw new MachineHaltError((ComputeHalt)advice);
        }
    }

    public final ComputeAdvice compute(long timeSlice) {
        if (this.stack == null) {
            return ComputeEnd.SINGLETON;
        }
        long computeAllowed = this.computeCount + timeSlice;
        while (this.computeCount < computeAllowed) {
            ++this.computeCount;
            this.current = this.stack;
            this.stack = this.stack.next;
            try {
                this.current.instr.compute(this.current.env, this);
            }
            catch (WaitException wx) {
                this.stack = this.current;
                this.current = null;
                return new ComputeWait(wx.barrier());
            }
            catch (NativeThrow nt) {
                ThrowInstr ti = new ThrowInstr(nt.error, nt, this.current.instr);
                this.stack = new Stack(ti, this.current.env, this.current);
            }
            catch (MachineError error) {
                return error.asComputeHalt(this.current);
            }
            catch (Throwable throwable) {
                NativeError ne = new NativeError(throwable);
                ThrowInstr ti = new ThrowInstr(ne, throwable, this.current.instr);
                this.stack = new Stack(ti, this.current.env, this.current);
            }
            if (this.stack != null) continue;
            return ComputeEnd.SINGLETON;
        }
        return ComputePreempt.SINGLETON;
    }

    public final long computeCount() {
        return this.computeCount;
    }

    public final Stack current() {
        return this.current;
    }

    public final <T> T owner() {
        return (T)this.owner;
    }

    final Stack popStackEntry() {
        Stack entry = this.stack;
        if (this.stack != null) {
            this.stack = this.stack.next;
        }
        return entry;
    }

    public final void pushStackEntries(List<Instr> instrs, Env env) {
        for (int i = instrs.size() - 1; i >= 0; --i) {
            this.stack = new Stack(instrs.get(i), env, this.stack);
        }
    }

    public final void pushStackEntry(Instr instr, Env env) {
        this.stack = new Stack(instr, env, this.stack);
    }

    public final Stack stack() {
        return this.stack;
    }

    final void unwindToJumpCatchInstr(JumpThrowInstr jumpThrowInstr) {
        int jumpThrowId = jumpThrowInstr.id;
        while (this.stack != null) {
            Instr instr = this.stack.instr;
            if (instr instanceof JumpCatchInstr) {
                JumpCatchInstr jumpCatchInstr = (JumpCatchInstr)instr;
                if (jumpCatchInstr.id == jumpThrowId) break;
            }
            this.stack = this.stack.next;
        }
        if (this.stack == null) {
            throw new UnmatchedJumpThrowError(jumpThrowInstr);
        }
    }

    final void unwindToNextCatchInstr(Complete error, Throwable nativeCause) {
        while (this.stack != null) {
            Instr instr = this.stack.instr;
            if (instr instanceof CatchInstr) {
                CatchInstr catchInstr = (CatchInstr)instr;
                Env catchEnv = Env.createPrivatelyForKlvm(this.stack.env, new EnvEntry[]{new EnvEntry(catchInstr.arg, new Var(error))});
                this.stack = new Stack(catchInstr.caseInstr, catchEnv, this.stack.next);
                break;
            }
            this.stack = this.stack.next;
        }
        if (this.stack == null) {
            throw new UncaughtThrowError(error, nativeCause);
        }
    }
}

