/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.math.BigDecimal;
import java.util.Set;
import org.torqlang.klvm.Bool;
import org.torqlang.klvm.Char;
import org.torqlang.klvm.Dec128;
import org.torqlang.klvm.Flt32;
import org.torqlang.klvm.Flt64;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Scalar;
import org.torqlang.klvm.UnificationError;
import org.torqlang.klvm.Value;

public interface Num
extends Scalar {
    public static final String NOT_A_DEC_128 = "Not a Dec128";
    public static final String NOT_A_NUM = "Not a Num";
    public static final String NOT_AN_INT_OR_FLT = "Not an Int or Flt";

    public static Num assertNum(Value value) {
        if (value instanceof Num) {
            Num num = (Num)value;
            return num;
        }
        throw new IllegalArgumentException(NOT_A_NUM);
    }

    @Override
    public Num add(Value var1);

    public Num addFrom(Dec128 var1);

    public Num addFrom(Char var1);

    public Num addFrom(Int32 var1);

    public Num addFrom(Int64 var1);

    public Num addFrom(Flt32 var1);

    public Num addFrom(Flt64 var1);

    @Override
    default public Num bindToValue(Value value, Set<Memo> memos) {
        if (!this.equals(value)) {
            throw new UnificationError(this, value);
        }
        return this;
    }

    public int compareValueFrom(Dec128 var1);

    public int compareValueFrom(Char var1);

    public int compareValueFrom(Int32 var1);

    public int compareValueFrom(Int64 var1);

    public int compareValueFrom(Flt32 var1);

    public int compareValueFrom(Flt64 var1);

    public BigDecimal decimal128Value();

    @Override
    public Num divide(Value var1);

    public Num divideFrom(Dec128 var1);

    public Num divideFrom(Char var1);

    public Num divideFrom(Int32 var1);

    public Num divideFrom(Int64 var1);

    public Num divideFrom(Flt32 var1);

    public Num divideFrom(Flt64 var1);

    public double doubleValue();

    @Override
    default public boolean entailsRec(Rec operand, Set<Memo> memos) {
        return false;
    }

    public float floatValue();

    @Override
    default public Bool greaterThan(Value operand) {
        return Bool.of(this.compareValueTo(Num.assertNum(operand)) > 0);
    }

    @Override
    default public Bool greaterThanOrEqualTo(Value operand) {
        return Bool.of(this.compareValueTo(Num.assertNum(operand)) >= 0);
    }

    public int intValue();

    @Override
    public boolean isValidKey();

    @Override
    default public Bool lessThan(Value operand) {
        return Bool.of(this.compareValueTo(Num.assertNum(operand)) < 0);
    }

    @Override
    default public Bool lessThanOrEqualTo(Value operand) {
        return Bool.of(this.compareValueTo(Num.assertNum(operand)) <= 0);
    }

    public long longValue();

    @Override
    public Num modulo(Value var1);

    public Num moduloFrom(Dec128 var1);

    public Num moduloFrom(Char var1);

    public Num moduloFrom(Int32 var1);

    public Num moduloFrom(Int64 var1);

    public Num moduloFrom(Flt32 var1);

    public Num moduloFrom(Flt64 var1);

    @Override
    public Num multiply(Value var1);

    public Num multiplyFrom(Dec128 var1);

    public Num multiplyFrom(Char var1);

    public Num multiplyFrom(Int32 var1);

    public Num multiplyFrom(Int64 var1);

    public Num multiplyFrom(Flt32 var1);

    public Num multiplyFrom(Flt64 var1);

    @Override
    public Num negate();

    @Override
    public Num subtract(Value var1);

    public Num subtractFrom(Dec128 var1);

    public Num subtractFrom(Char var1);

    public Num subtractFrom(Int32 var1);

    public Num subtractFrom(Int64 var1);

    public Num subtractFrom(Flt32 var1);

    public Num subtractFrom(Flt64 var1);
}

