/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.IdentityHashMap;
import org.torqlang.klvm.AbstractClosure;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteClosure;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.EnvEntry;
import org.torqlang.klvm.Partial;
import org.torqlang.klvm.ProcDef;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitVarException;

public class PartialClosure
extends AbstractClosure
implements Partial {
    public PartialClosure(ProcDef procDef, Env capturedEnv) {
        super(procDef, capturedEnv);
    }

    @Override
    public CompleteClosure checkComplete() throws WaitVarException {
        return this.checkComplete(new IdentityHashMap());
    }

    @Override
    public final CompleteClosure checkComplete(IdentityHashMap<Partial, Complete> memos) throws WaitVarException {
        Complete previous = memos.get(this);
        if (previous != null) {
            return (CompleteClosure)previous;
        }
        if (this.capturedEnv.parentEnv() != null) {
            throw new IllegalStateException("Invalid closure environment");
        }
        CompleteClosure thisCompleteClosure = CompleteClosure.instanceForRestore();
        memos.put(this, thisCompleteClosure);
        EnvEntry[] envEntries = new EnvEntry[this.capturedEnv.shallowSize()];
        int nextIndex = 0;
        for (EnvEntry envEntry : this.capturedEnv) {
            Complete completeValue;
            Value resolvedValue = envEntry.var.resolveValue();
            if (resolvedValue instanceof Partial) {
                Partial partial = (Partial)resolvedValue;
                completeValue = partial.checkComplete(memos);
            } else {
                completeValue = resolvedValue.checkComplete();
            }
            envEntries[nextIndex++] = new EnvEntry(envEntry.ident, new Var(completeValue));
        }
        thisCompleteClosure.restore(this.procDef, Env.createPrivatelyForKlvm(null, envEntries));
        return thisCompleteClosure;
    }
}

