/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.torqlang.klvm.Composite;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureComparator;
import org.torqlang.klvm.FeatureNotFoundError;
import org.torqlang.klvm.ObjProcTable;
import org.torqlang.klvm.PartialField;
import org.torqlang.klvm.PartialObj;
import org.torqlang.klvm.PartialObjProc;
import org.torqlang.klvm.PartialObjProcBinding;
import org.torqlang.klvm.Proc;
import org.torqlang.util.BinarySearchTools;

public final class PartialObjProcTable<T extends PartialObj>
implements ObjProcTable<T> {
    private final Entry<T>[] entries;

    private PartialObjProcTable(List<Entry<T>> entries) {
        this.entries = entries.toArray(new Entry[0]);
        Arrays.sort(this.entries, (a, b) -> FeatureComparator.SINGLETON.compare(a.feature, b.feature));
    }

    public static <T extends PartialObj> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public final Feature featureAt(int index) {
        return this.entries[index].feature;
    }

    @Override
    public final PartialField fieldAt(int index) {
        Entry<T> entry = this.entries[index];
        return new PartialField(entry.feature, (Proc)((Object)entry.objProc));
    }

    @Override
    public final int fieldCount() {
        return this.entries.length;
    }

    @Override
    public final PartialObjProcBinding<T> selectAndBind(T target, Feature selector) {
        int index = BinarySearchTools.search((Object[])this.entries, e -> FeatureComparator.SINGLETON.compare(selector, e.feature));
        if (index < 0) {
            throw new FeatureNotFoundError((Composite)target, selector);
        }
        return new PartialObjProcBinding<T>(target, this.entries[index].objProc);
    }

    @Override
    public final Proc valueAt(T target, int index) {
        Feature feature = this.entries[index].feature;
        return this.selectAndBind(target, feature);
    }

    private record Entry<T extends PartialObj>(Feature feature, PartialObjProc<T> objProc) {
    }

    public static class Builder<T extends PartialObj> {
        private final List<Entry<T>> entries = new ArrayList<Entry<T>>();

        private Builder() {
        }

        public Builder<T> addEntry(Feature feature, PartialObjProc<T> objProc) {
            this.entries.add(new Entry<T>(feature, objProc));
            return this;
        }

        public PartialObjProcTable<T> build() {
            return new PartialObjProcTable<T>(this.entries);
        }
    }
}

