/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.List;
import org.torqlang.klvm.BasicPartialRec;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureOrVar;
import org.torqlang.klvm.Field;
import org.torqlang.klvm.FutureField;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.LiteralOrVar;
import org.torqlang.klvm.PartialField;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;

public final class PartialRecBuilder {
    private LiteralOrVar label;
    private boolean completeOnly = true;
    private final List<Field> fields = new ArrayList<Field>();

    PartialRecBuilder() {
    }

    public final PartialRecBuilder addField(Feature feature, ValueOrVar valueOrVar) {
        if (valueOrVar instanceof Complete) {
            Complete complete = (Complete)valueOrVar;
            this.addField(new CompleteField(feature, complete));
        } else {
            this.addField(new PartialField(feature, valueOrVar));
        }
        return this;
    }

    public final PartialRecBuilder addField(Field field) {
        if (!(field instanceof CompleteField)) {
            this.completeOnly = false;
        }
        this.fields.add(field);
        return this;
    }

    public final PartialRecBuilder addField(FeatureOrVar featureOrVar, ValueOrVar valueOrVar) {
        if (featureOrVar instanceof Feature) {
            Feature feature = (Feature)featureOrVar;
            this.addField(feature, valueOrVar);
        } else {
            this.addField(new FutureField((Var)featureOrVar, valueOrVar));
        }
        return this;
    }

    public final Rec build() {
        if (this.isComplete()) {
            ArrayList<CompleteField> completeFields = new ArrayList<CompleteField>();
            for (Field f : this.fields) {
                completeFields.add((CompleteField)f);
            }
            return CompleteRec.create((Literal)this.label, completeFields);
        }
        ArrayList<FutureField> futureFields = new ArrayList<FutureField>(this.fields.size());
        ArrayList<PartialField> partialFields = new ArrayList<PartialField>(this.fields.size());
        for (Field f : this.fields) {
            if (f instanceof CompleteField) {
                CompleteField cf = (CompleteField)f;
                partialFields.add(new PartialField(cf.feature, cf.value));
                continue;
            }
            if (f instanceof PartialField) {
                PartialField pf = (PartialField)f;
                partialFields.add(pf);
                continue;
            }
            futureFields.add((FutureField)f);
        }
        return BasicPartialRec.createPrivatelyForKlvm(this.label, futureFields, partialFields);
    }

    private boolean isComplete() {
        return this.isLiteralOrNull(this.label) && this.completeOnly;
    }

    private boolean isLiteralOrNull(LiteralOrVar label) {
        return label == null || label instanceof Literal;
    }

    public final PartialRecBuilder setLabel(LiteralOrVar label) {
        this.label = label;
        return this;
    }
}

