/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.List;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteTuple;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.LiteralOrVar;
import org.torqlang.klvm.PartialTuple;
import org.torqlang.klvm.Tuple;
import org.torqlang.klvm.ValueOrVar;

public final class PartialTupleBuilder {
    private final List<ValueOrVar> values = new ArrayList<ValueOrVar>();
    private LiteralOrVar label;
    private boolean completeOnly = true;

    PartialTupleBuilder() {
    }

    public final PartialTupleBuilder addValue(ValueOrVar valueOrVar) {
        if (!(valueOrVar instanceof Complete)) {
            this.completeOnly = false;
        }
        this.values.add(valueOrVar);
        return this;
    }

    public final Tuple build() {
        if (!this.isComplete()) {
            return PartialTuple.create(this.label, this.values);
        }
        ArrayList<Complete> completeValues = new ArrayList<Complete>(this.values.size());
        for (ValueOrVar valueOrVar : this.values) {
            completeValues.add((Complete)valueOrVar);
        }
        return CompleteTuple.create((Literal)this.label, completeValues);
    }

    private boolean isComplete() {
        return this.isLiteralOrNull(this.label) && this.completeOnly;
    }

    private boolean isLiteralOrNull(LiteralOrVar label) {
        return label == null || label instanceof Literal;
    }

    public final PartialTupleBuilder setLabel(LiteralOrVar label) {
        this.label = label;
        return this;
    }
}

