/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.torqlang.klvm.Decl;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.util.ListTools;
import org.torqlang.util.SourceSpan;

public final class ProcDef
implements Decl {
    public final List<Ident> xs;
    public final Instr instr;
    public final SourceSpan sourceSpan;
    public final Set<Ident> freeIdents;

    public ProcDef(List<Ident> xs, Instr instr, SourceSpan sourceSpan) {
        this.xs = ListTools.nullSafeCopyOf(xs);
        this.instr = instr;
        this.sourceSpan = sourceSpan;
        HashSet<Ident> kb = new HashSet<Ident>(this.xs);
        HashSet<Ident> lf = new HashSet<Ident>();
        instr.captureLexicallyFree(kb, lf);
        this.freeIdents = Set.copyOf(lf);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitProcDef(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        for (Ident freeIdent : this.freeIdents) {
            if (knownBound.contains(freeIdent)) continue;
            lexicallyFree.add(freeIdent);
        }
    }

    public final String toString() {
        return this.toKernelString();
    }
}

