/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CommonFeatures;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Eof;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.PartialProc;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class RangeIterMod
implements KernelModule {
    public static final Str RANGE_ITER_STR = Str.of("RangeIter");
    public static final Ident RANGE_ITER_IDENT = Ident.create(RangeIterMod.RANGE_ITER_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().addField(CommonFeatures.$NEW, RangeIterMod::clsNew).build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(RANGE_ITER_STR, this.namesake).build();

    private RangeIterMod() {
    }

    public static RangeIterMod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void clsNew(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedArgCount = 3;
        if (ys.size() != 3) {
            throw new InvalidArgCountError(3, ys, "RangeIter.new");
        }
        Int64 fromInt = (Int64)ys.get(0).resolveValue(env);
        Int64 toInt = (Int64)ys.get(1).resolveValue(env);
        RangeIterObj rangeIter = new RangeIterObj(fromInt, toInt);
        ValueOrVar target = ys.get(2).resolveValueOrVar(env);
        target.bindToValue(rangeIter, null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return RANGE_ITER_IDENT;
    }

    private static final class LazySingleton {
        private static final RangeIterMod SINGLETON = new RangeIterMod();

        private LazySingleton() {
        }
    }

    static final class RangeIterObj
    implements PartialProc {
        private static final int RANGE_ITER_ARG_COUNT = 1;
        private final Int64 fromInt;
        private final Int64 toInt;
        private Int64 nextInt;

        public RangeIterObj(Int64 fromInt, Int64 toInt) {
            this.fromInt = fromInt;
            this.toInt = toInt;
            this.nextInt = fromInt;
        }

        @Override
        public final void apply(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
            if (ys.size() != 1) {
                throw new InvalidArgCountError(1, ys, this);
            }
            ValueOrVar y = ys.get(0).resolveValueOrVar(env);
            if (this.nextInt.compareValueTo(this.toInt) < 0) {
                y.bindToValue(this.nextInt, null);
                this.nextInt = (Int64)this.nextInt.addFrom(Int32.I32_1);
            } else {
                y.bindToValue(Eof.SINGLETON, null);
            }
        }

        @Override
        public final boolean isValidKey() {
            return true;
        }

        public final String toString() {
            return this.toKernelString();
        }
    }
}

