/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRecBuilder;
import org.torqlang.klvm.CompleteTupleBuilder;
import org.torqlang.klvm.Composite;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.EnvEntry;
import org.torqlang.klvm.Eof;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureComparator;
import org.torqlang.klvm.Field;
import org.torqlang.klvm.FieldIter;
import org.torqlang.klvm.FieldIterSource;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Null;
import org.torqlang.klvm.PartialRecBuilder;
import org.torqlang.klvm.PartialTuple;
import org.torqlang.klvm.PartialTupleBuilder;
import org.torqlang.klvm.ResolvedFieldPtn;
import org.torqlang.klvm.ResolvedRecPtn;
import org.torqlang.klvm.UnificationError;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueIter;
import org.torqlang.klvm.ValueIterSource;
import org.torqlang.klvm.ValueOrIdent;
import org.torqlang.klvm.ValueOrPtn;
import org.torqlang.klvm.ValueOrResolvedPtn;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitException;
import org.torqlang.klvm.WaitVarException;

public interface Rec
extends Composite,
FieldIterSource,
ValueIterSource {
    public static final Collection<Var> EMPTY_VAR_COLLECTION = Collections.emptyList();
    public static final FeatureComparator FEATURE_COMPARATOR = FeatureComparator.SINGLETON;
    public static final Null DEFAULT_LABEL = Null.SINGLETON;
    public static final String $LABEL = "$label";
    public static final String $FIELDS = "$fields";

    public static CompleteRecBuilder completeRecBuilder() {
        return new CompleteRecBuilder();
    }

    public static CompleteRecBuilder completeRecBuilder(Literal label, List<CompleteField> fields) {
        return new CompleteRecBuilder(label, fields);
    }

    public static CompleteTupleBuilder completeTupleBuilder() {
        return new CompleteTupleBuilder();
    }

    public static PartialRecBuilder partialRecBuilder() {
        return new PartialRecBuilder();
    }

    public static PartialTupleBuilder partialTupleBuilder() {
        return new PartialTupleBuilder();
    }

    @Override
    default public <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitRec(this, state);
    }

    @Override
    default public Rec bindToValue(Value value, Set<Memo> memos) throws WaitVarException {
        return value.unifyRecs(this, memos);
    }

    @Override
    default public ValueOrResolvedPtn caseNonRecOfThis(Value nonRecValue, Env env) {
        return null;
    }

    @Override
    default public ValueOrResolvedPtn caseOf(ValueOrPtn valueOrPtn, Env env) throws WaitException {
        return valueOrPtn.caseRecOfThis(this, env);
    }

    @Override
    default public ValueOrResolvedPtn caseRecOfThis(Rec rec, Env env) throws WaitException {
        return rec.entails(this, null) ? this : null;
    }

    default public void checkDetermined() throws WaitVarException {
        Collection<Var> undetermined = this.sweepUndeterminedVars();
        if (!undetermined.isEmpty()) {
            Var any = undetermined.iterator().next();
            throw new WaitVarException(any);
        }
    }

    @Override
    default public Env deconstruct(ValueOrResolvedPtn valueOrResolvedPtn, Env env) {
        ResolvedRecPtn resRecPtn = (ResolvedRecPtn)valueOrResolvedPtn;
        ArrayList<EnvEntry> bindings = new ArrayList<EnvEntry>(resRecPtn.fields.size());
        for (ResolvedFieldPtn fieldPtn : resRecPtn.fields) {
            ValueOrIdent valueOrIdent = fieldPtn.value;
            if (!(valueOrIdent instanceof Ident)) continue;
            Ident valueIdent = (Ident)valueOrIdent;
            ValueOrVar valueOrVar = this.findValue(fieldPtn.feature);
            if (valueOrVar instanceof Value) {
                Value value = (Value)valueOrVar;
                bindings.add(new EnvEntry(valueIdent, new Var(value)));
                continue;
            }
            bindings.add(new EnvEntry(valueIdent, (Var)valueOrVar));
        }
        return Env.create(env, bindings);
    }

    @Override
    default public boolean entails(Value operand, Set<Memo> memos) throws WaitVarException {
        return operand.entailsRec(this, memos);
    }

    @Override
    default public boolean entailsRec(Rec other, Set<Memo> memos) throws WaitVarException {
        if (this == other) {
            return true;
        }
        this.checkDetermined();
        other.checkDetermined();
        Memo here = new Memo(this, other);
        if (memos == null) {
            memos = new HashSet<Memo>();
        } else if (memos.contains(here)) {
            return true;
        }
        memos.add(here);
        if (!this.label().equals(other.label())) {
            return false;
        }
        if (!this.equalFeatures(other)) {
            return false;
        }
        int fc = this.fieldCount();
        for (int i = 0; i < fc; ++i) {
            boolean entails = this.valueAt(i).entailsValueOrVar(other.valueAt(i), memos);
            if (entails) continue;
            return false;
        }
        return true;
    }

    default public boolean equalFeatures(Rec other) {
        int fc = this.fieldCount();
        if (fc != other.fieldCount()) {
            return false;
        }
        for (int i = 0; i < fc; ++i) {
            if (this.featureAt(i).equals(other.featureAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    default public ValueOrVar fieldIter() throws WaitException {
        this.checkDetermined();
        return new RecFieldIter(this);
    }

    public ValueOrVar findValue(Feature var1);

    public void setUnifiedValue(int var1, ValueOrVar var2);

    default public Collection<Var> sweepUndeterminedVars() {
        return EMPTY_VAR_COLLECTION;
    }

    public int unificationPriority();

    default public void unifyFields(Rec other, int index, Set<Memo> memos) throws WaitVarException {
        ValueOrVar thisValue = this.valueAt(index);
        ValueOrVar otherValue = other.valueAt(index);
        ValueOrVar unifiedValueOrVar = thisValue.bindToValueOrVar(otherValue, memos);
        this.setUnifiedValue(index, unifiedValueOrVar);
        other.setUnifiedValue(index, unifiedValueOrVar);
    }

    @Override
    default public Rec unifyRecs(Rec other, Set<Memo> memos) throws WaitVarException {
        if (this == other) {
            return this;
        }
        this.checkDetermined();
        other.checkDetermined();
        Memo here = new Memo(this, other);
        if (memos == null) {
            memos = new HashSet<Memo>();
        } else if (memos.contains(here)) {
            return this;
        }
        memos.add(here);
        if (!this.label().equals(other.label())) {
            throw new UnificationError(this, other.label());
        }
        if (!this.equalFeatures(other)) {
            throw new UnificationError(this, other);
        }
        int fc = this.fieldCount();
        for (int i = 0; i < fc; ++i) {
            this.unifyFields(other, i, memos);
        }
        return other.unificationPriority() > this.unificationPriority() ? other : this;
    }

    @Override
    default public ValueOrVar valueIter() throws WaitException {
        this.checkDetermined();
        return new RecValueIter(this);
    }

    public static class RecFieldIter
    implements FieldIter {
        private final Rec rec;
        private int nextIndex = 0;

        RecFieldIter(Rec rec) {
            this.rec = rec;
        }

        @Override
        public void apply(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
            Composite next;
            if (ys.size() != 1) {
                throw new InvalidArgCountError(1, ys, this);
            }
            int size = this.rec.fieldCount();
            if (this.nextIndex < size) {
                Field nextField = this.rec.fieldAt(this.nextIndex);
                next = PartialTuple.create(null, List.of(nextField.feature(), nextField.value()));
                ++this.nextIndex;
            } else {
                next = Eof.SINGLETON;
            }
            ValueOrVar target = ys.get(0).resolveValueOrVar(env);
            target.bindToValueOrVar(next, null);
        }
    }

    public static class RecValueIter
    implements ValueIter {
        private final Rec rec;
        private int nextIndex = 0;

        RecValueIter(Rec rec) {
            this.rec = rec;
        }

        @Override
        public void apply(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
            ValueOrVar next;
            if (ys.size() != 1) {
                throw new InvalidArgCountError(1, ys, this);
            }
            int size = this.rec.fieldCount();
            if (this.nextIndex < size) {
                next = this.rec.valueAt(this.nextIndex);
                ++this.nextIndex;
            } else {
                next = Eof.SINGLETON;
            }
            ValueOrVar target = ys.get(0).resolveValueOrVar(env);
            target.bindToValueOrVar(next, null);
        }
    }
}

