/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import java.util.Set;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Decl;
import org.torqlang.klvm.FieldDef;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.LiteralOrIdent;
import org.torqlang.util.ListTools;
import org.torqlang.util.SourceSpan;

public final class RecDef
implements Decl {
    public final LiteralOrIdent label;
    public final List<FieldDef> fieldDefs;
    public final SourceSpan sourceSpan;

    public RecDef(LiteralOrIdent label, List<FieldDef> fieldDefs, SourceSpan sourceSpan) {
        this.label = label;
        this.fieldDefs = ListTools.nullSafeCopyOf(fieldDefs);
        this.sourceSpan = sourceSpan;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitRecDef(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.label, knownBound, lexicallyFree);
        for (FieldDef fd : this.fieldDefs) {
            fd.captureLexicallyFree(knownBound, lexicallyFree);
        }
    }

    public final int fieldCount() {
        return this.fieldDefs.size();
    }

    public final FieldDef fieldDefAtIndex(int i) {
        return this.fieldDefs.get(i);
    }

    public final String toString() {
        return this.toKernelString();
    }
}

