/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CommonFeatures;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Int32;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.PartialRecBuilder;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class RecMod
implements KernelModule {
    public static final Str REC_STR = Str.of("Rec");
    public static final Ident REC_IDENT = Ident.create(RecMod.REC_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().addField(CommonFeatures.ASSIGN, RecMod::clsAssign).addField(CommonFeatures.SIZE, RecMod::clsSize).build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(REC_STR, this.namesake).build();

    private RecMod() {
    }

    public static RecMod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void clsAssign(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedArgCount = 3;
        if (ys.size() != 3) {
            throw new InvalidArgCountError(3, ys, "Rec.assign");
        }
        PartialRecBuilder builder = Rec.partialRecBuilder();
        Rec rec0 = (Rec)ys.get(0).resolveValue(env);
        rec0.checkDetermined();
        for (int i = 0; i < rec0.fieldCount(); ++i) {
            builder.addField(rec0.featureAt(i), rec0.valueAt(i));
        }
        Rec rec1 = (Rec)ys.get(1).resolveValue(env);
        rec1.checkDetermined();
        for (int i = 0; i < rec1.fieldCount(); ++i) {
            Feature rec1Feat = rec1.featureAt(i);
            if (rec0.findValue(rec1Feat) != null) continue;
            builder.addField(rec1Feat, rec1.valueAt(i));
        }
        Rec assigned = builder.build();
        ValueOrVar target = ys.get(2).resolveValueOrVar(env);
        target.bindToValue(assigned, null);
    }

    static void clsSize(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedArgCount = 2;
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "Rec.size");
        }
        Rec rec0 = (Rec)ys.get(0).resolveValue(env);
        rec0.checkDetermined();
        ValueOrVar target = ys.get(1).resolveValueOrVar(env);
        target.bindToValue(Int32.of(rec0.fieldCount()), null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return REC_IDENT;
    }

    private static final class LazySingleton {
        private static final RecMod SINGLETON = new RecMod();

        private LazySingleton() {
        }
    }
}

