/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Composite;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.FeatureOrIdent;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Proc;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.ListTools;
import org.torqlang.util.SourceSpan;

public final class SelectAndApplyInstr
extends AbstractInstr {
    public final CompleteOrIdent rec;
    public final List<FeatureOrIdent> path;
    public final List<CompleteOrIdent> args;

    public SelectAndApplyInstr(CompleteOrIdent rec, List<FeatureOrIdent> path, List<CompleteOrIdent> args, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.rec = rec;
        this.path = path;
        this.args = ListTools.nullSafeCopyOf(args);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitSelectAndApplyInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.rec, knownBound, lexicallyFree);
        for (FeatureOrIdent f : this.path) {
            CompleteOrIdent.captureLexicallyFree(f, knownBound, lexicallyFree);
        }
        for (CompleteOrIdent a : this.args) {
            CompleteOrIdent.captureLexicallyFree(a, knownBound, lexicallyFree);
        }
    }

    @Override
    public final void compute(Env env, Machine machine) throws WaitException {
        Value selectedValue = this.rec.resolveValue(env);
        for (FeatureOrIdent f : this.path) {
            Composite composite = (Composite)selectedValue;
            Feature featureRes = (Feature)f.resolveValue(env);
            selectedValue = composite.select(featureRes).resolveValue();
        }
        Proc p = (Proc)selectedValue;
        p.apply(this.args, env, machine);
    }
}

