/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Composite;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.IdentNotFoundError;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public final class SelectInstr
extends AbstractInstr {
    public final CompleteOrIdent rec;
    public final CompleteOrIdent feature;
    public final Ident target;

    public SelectInstr(CompleteOrIdent rec, CompleteOrIdent feature, Ident target, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.rec = rec;
        this.feature = feature;
        this.target = target;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitSelectInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.rec, knownBound, lexicallyFree);
        CompleteOrIdent.captureLexicallyFree(this.feature, knownBound, lexicallyFree);
        Ident.captureLexicallyFree(this.target, knownBound, lexicallyFree);
    }

    @Override
    public final void compute(Env env, Machine machine) throws WaitException {
        Composite recRes = (Composite)this.rec.resolveValue(env);
        Feature featureRes = (Feature)this.feature.resolveValue(env);
        ValueOrVar selectedValue = recRes.select(featureRes);
        Var targetVar = env.get(this.target);
        if (targetVar == null) {
            throw new IdentNotFoundError(this.target, this);
        }
        targetVar.bindToValueOrVar(selectedValue, null);
    }
}

