/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Instr;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.util.ListTools;
import org.torqlang.util.SourceSpan;

public final class SeqInstr
extends AbstractInstr {
    public final List<Instr> list;

    public SeqInstr(List<Instr> list, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.list = ListTools.nullSafeCopyOf(list);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitSeqInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        for (Instr instr : this.list) {
            instr.captureLexicallyFree(new HashSet<Ident>(knownBound), lexicallyFree);
        }
    }

    @Override
    public void compute(Env env, Machine machine) {
        machine.pushStackEntries(this.list, env);
    }

    @Override
    public void pushStackEntries(Machine machine, Env env) {
        machine.pushStackEntries(this.list, env);
    }
}

