/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.CellMod;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;
import org.torqlang.util.SourceSpan;

public final class SetCellValueInstr
extends AbstractInstr {
    public final Ident cell;
    public final CompleteOrIdent value;

    public SetCellValueInstr(Ident cell, CompleteOrIdent value, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.cell = cell;
        this.value = value;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitSetCellValueInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.cell, knownBound, lexicallyFree);
        CompleteOrIdent.captureLexicallyFree(this.value, knownBound, lexicallyFree);
    }

    public final CompleteOrIdent cell() {
        return this.cell;
    }

    @Override
    public void compute(Env env, Machine machine) throws WaitException {
        CellMod.CellObj cellObj = (CellMod.CellObj)this.cell.resolveValue(env);
        ValueOrVar valueRes = this.value.resolveValueOrVar(env);
        cellObj.set(valueRes);
    }

    public final CompleteOrIdent value() {
        return this.value;
    }
}

