/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.Bool;
import org.torqlang.klvm.CompleteField;
import org.torqlang.klvm.CompleteObjProcTable;
import org.torqlang.klvm.CompleteProc;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Null;
import org.torqlang.klvm.Proc;
import org.torqlang.klvm.StrMod;
import org.torqlang.klvm.Value;
import org.torqlang.util.EscapeChar;
import org.torqlang.util.SourceString;

public final class Str
implements Literal {
    private static final CompleteObjProcTable<Str> objProcTable = CompleteObjProcTable.builder().addEntry(Str.of("substring"), StrMod::objSubstring).build();
    public final String value;

    private Str(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.value = value;
    }

    private static char decodeChar(char encodedChar) {
        if (encodedChar == 'r') {
            return '\r';
        }
        if (encodedChar == 'n') {
            return '\n';
        }
        if (encodedChar == 't') {
            return '\t';
        }
        if (encodedChar == 'f') {
            return '\f';
        }
        if (encodedChar == 'b') {
            return '\b';
        }
        if (encodedChar == '\\') {
            return '\\';
        }
        if (encodedChar == '\'') {
            return '\'';
        }
        if (encodedChar == '\"') {
            return '\"';
        }
        throw new IllegalArgumentException("Invalid escape sequence: \\" + encodedChar);
    }

    public static Str of(String value) {
        return new Str(value);
    }

    public static String quote(String value, char delimiter) {
        StringBuilder sb = new StringBuilder(value.length() * 2 + 2);
        Str.quote(value, delimiter, sb);
        return sb.toString();
    }

    public static void quote(String source, char delimiter, StringBuilder sb) {
        sb.append(delimiter);
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c < ' ') {
                EscapeChar.apply((char)c, (StringBuilder)sb);
                continue;
            }
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == delimiter) {
                sb.append("\\");
                sb.append(delimiter);
                continue;
            }
            sb.append(c);
        }
        sb.append(delimiter);
    }

    public static String unquote(SourceString source, int begin, int end) {
        StringBuilder sb = new StringBuilder((--end - ++begin) * 2);
        int i = begin;
        while (i < end) {
            char c1 = source.charAt(i);
            if (c1 == '\\') {
                char c2 = source.charAt(i + 1);
                if (c2 == 'u') {
                    int code = Integer.parseInt("" + source.charAt(i + 2) + source.charAt(i + 3) + source.charAt(i + 4) + source.charAt(i + 5), 16);
                    sb.append(Character.toChars(code));
                    i += 6;
                    continue;
                }
                c1 = Str.decodeChar(c2);
                sb.append(c1);
                i += 2;
                continue;
            }
            sb.append(c1);
            ++i;
        }
        return sb.toString();
    }

    public static String unquote(String source, int begin, int end) {
        StringBuilder sb = new StringBuilder((--end - ++begin) * 2);
        int i = begin;
        while (i < end) {
            char c1 = source.charAt(i);
            if (c1 == '\\') {
                char c2 = source.charAt(i + 1);
                if (c2 == 'u') {
                    int code = Integer.parseInt("" + source.charAt(i + 2) + source.charAt(i + 3) + source.charAt(i + 4) + source.charAt(i + 5), 16);
                    sb.append(Character.toChars(code));
                    i += 6;
                    continue;
                }
                c1 = Str.decodeChar(c2);
                sb.append(c1);
                i += 2;
                continue;
            }
            sb.append(c1);
            ++i;
        }
        return sb.toString();
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitScalar(this, state);
    }

    @Override
    public final Str add(Value addend) {
        return Str.of(addend.appendToString(this.value));
    }

    @Override
    public final String appendToString(String string) {
        return string + this.value;
    }

    @Override
    public final int compareValueTo(Value right) {
        if (!(right instanceof Str)) {
            throw new IllegalArgumentException("Argument must be a Str");
        }
        Str s = (Str)right;
        return this.value.compareTo(s.value);
    }

    @Override
    public final boolean entails(Value operand, Set<Memo> memos) {
        return this.equals(operand);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Str that = (Str)other;
        return this.value.equals(that.value);
    }

    @Override
    public final String formatAsKernelString() {
        return Str.quote(this.value, '\'');
    }

    @Override
    public final Bool greaterThan(Value right) {
        if (!(right instanceof Str)) {
            throw new IllegalArgumentException("Argument must be a Str");
        }
        Str s = (Str)right;
        return Bool.of(this.value.compareTo(s.value) > 0);
    }

    @Override
    public final Bool greaterThanOrEqualTo(Value right) {
        if (!(right instanceof Str)) {
            throw new IllegalArgumentException("Argument must be a Str");
        }
        Str s = (Str)right;
        return Bool.of(this.value.compareTo(s.value) >= 0);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public final Feature featureAt(int index) {
        return objProcTable.featureAt(index);
    }

    @Override
    public final CompleteField fieldAt(int index) {
        return objProcTable.fieldAt(index);
    }

    @Override
    public final int fieldCount() {
        return objProcTable.fieldCount();
    }

    @Override
    public Literal label() {
        return Null.SINGLETON;
    }

    @Override
    public final Bool lessThan(Value right) {
        if (!(right instanceof Str)) {
            throw new IllegalArgumentException("Argument must be a Str");
        }
        Str s = (Str)right;
        return Bool.of(this.value.compareTo(s.value) < 0);
    }

    @Override
    public final Bool lessThanOrEqualTo(Value right) {
        if (!(right instanceof Str)) {
            throw new IllegalArgumentException("Argument must be a Str");
        }
        Str s = (Str)right;
        return Bool.of(this.value.compareTo(s.value) <= 0);
    }

    @Override
    public final Proc select(Feature feature) {
        return objProcTable.selectAndBind(this, feature);
    }

    @Override
    public final String toNativeValue() {
        return this.value;
    }

    public final String toString() {
        return this.value;
    }

    @Override
    public final CompleteProc valueAt(int index) {
        return objProcTable.valueAt(this, index);
    }
}

