/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.Int64;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class StrMod
implements KernelModule {
    public static final Str STR_STR = Str.of("Str");
    public static final Ident STR_IDENT = Ident.create(StrMod.STR_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(STR_STR, this.namesake).build();

    private StrMod() {
    }

    public static StrMod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void objSubstring(Str obj, List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        ValueOrVar target;
        Str subStr;
        int argCount = ys.size();
        if (argCount < 2 || argCount > 3) {
            throw new InvalidArgCountError(2, 3, ys, "Str.substring");
        }
        Int64 beginIndex = (Int64)ys.get(0).resolveValue(env);
        if (argCount == 2) {
            subStr = Str.of(obj.value.substring(beginIndex.intValue()));
            target = ys.get(1).resolveValueOrVar(env);
        } else {
            Int64 endIndex = (Int64)ys.get(1).resolveValue(env);
            subStr = Str.of(obj.value.substring(beginIndex.intValue(), endIndex.intValue()));
            target = ys.get(2).resolveValueOrVar(env);
        }
        target.bindToValueOrVar(subStr, null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return STR_IDENT;
    }

    private static final class LazySingleton {
        private static final StrMod SINGLETON = new StrMod();

        private LazySingleton() {
        }
    }
}

