/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.AbstractInstr;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.Var;
import org.torqlang.util.SourceSpan;

public final class ThrowInstr
extends AbstractInstr {
    public final CompleteOrIdent error;
    public final Throwable nativeCause;

    public ThrowInstr(CompleteOrIdent error, SourceSpan sourceSpan) {
        this(error, null, sourceSpan);
    }

    public ThrowInstr(CompleteOrIdent error, Throwable nativeCause, SourceSpan sourceSpan) {
        super(sourceSpan);
        this.error = error;
        this.nativeCause = nativeCause;
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitThrowInstr(this, state);
    }

    @Override
    public final void captureLexicallyFree(Set<Ident> knownBound, Set<Ident> lexicallyFree) {
        CompleteOrIdent.captureLexicallyFree(this.error, knownBound, lexicallyFree);
    }

    @Override
    public final void compute(Env env, Machine machine) {
        ValueOrVar errorValueOrVar = this.error.resolveValueOrVar(env);
        if (!(errorValueOrVar instanceof Complete)) {
            if (errorValueOrVar instanceof Var) {
                throw new IllegalArgumentException("This code is attempting to throw an exception with an unbound identifier: " + String.valueOf(this.error) + ". The actual exception cannot be thrown.");
            }
            throw new IllegalStateException("This code is attempting to throw an exception with a partial value: " + String.valueOf(errorValueOrVar) + ". The actual exception cannot be thrown.");
        }
        Complete complete = (Complete)errorValueOrVar;
        machine.unwindToNextCatchInstr(complete, this.nativeCause);
    }
}

