/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import java.util.Set;
import org.torqlang.klvm.Bool;
import org.torqlang.klvm.CannotCompleteError;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.EnvEntry;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.ResolvedIdentPtn;
import org.torqlang.klvm.UnificationError;
import org.torqlang.klvm.ValueOrIdent;
import org.torqlang.klvm.ValueOrIdentPtn;
import org.torqlang.klvm.ValueOrPtn;
import org.torqlang.klvm.ValueOrResolvedPtn;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.ValueOrVarSet;
import org.torqlang.klvm.Var;
import org.torqlang.klvm.WaitException;
import org.torqlang.klvm.WaitVarException;

public interface Value
extends ValueOrIdent,
ValueOrVar,
ValueOrVarSet,
ValueOrIdentPtn,
ValueOrResolvedPtn {
    public static final Object PRESENT = new Object();

    default public Value add(Value addend) {
        throw new UnsupportedOperationException("Add not supported");
    }

    default public String appendToString(String string) {
        return string + String.valueOf(this);
    }

    @Override
    public Value bindToValue(Value var1, Set<Memo> var2) throws WaitVarException;

    @Override
    default public Value bindToValueOrVar(ValueOrVar valueOrVar, Set<Memo> memos) throws WaitVarException {
        return valueOrVar.bindToValue(this, memos);
    }

    @Override
    default public Value bindToVar(Var var, Set<Memo> memos) throws WaitVarException {
        return var.bindToValue(this, memos);
    }

    @Override
    default public ValueOrResolvedPtn caseNonRecOfThis(Value nonRecValue, Env env) throws WaitException {
        return nonRecValue.entails(this, null) ? this : null;
    }

    default public ValueOrResolvedPtn caseOf(ValueOrPtn valueOrPtn, Env env) throws WaitException {
        return valueOrPtn.caseNonRecOfThis(this, env);
    }

    @Override
    default public ValueOrResolvedPtn caseRecOfThis(Rec rec, Env env) throws WaitException {
        return null;
    }

    @Override
    default public Complete checkComplete() throws WaitVarException {
        throw new CannotCompleteError(this);
    }

    default public Value checkNotFailedValue() {
        return this;
    }

    default public int compareValueTo(Value right) {
        throw new UnsupportedOperationException("compareValueTo not supported");
    }

    default public Env deconstruct(ValueOrResolvedPtn valueOrResolvedPtn, Env env) {
        if (valueOrResolvedPtn instanceof ResolvedIdentPtn) {
            ResolvedIdentPtn identPtn = (ResolvedIdentPtn)valueOrResolvedPtn;
            return Env.create(env, List.of(new EnvEntry(identPtn.ident, new Var(this))));
        }
        return env;
    }

    default public Bool disentails(Value operand) throws WaitException {
        return Bool.of(!this.entails(operand, null));
    }

    default public Value divide(Value divisor) {
        throw new UnsupportedOperationException("Divide not supported");
    }

    default public Bool entails(Value operand) throws WaitVarException {
        return Bool.of(this.entails(operand, null));
    }

    @Override
    default public boolean entails(Value operand, Set<Memo> memos) throws WaitVarException {
        return this == operand;
    }

    public boolean entailsRec(Rec var1, Set<Memo> var2) throws WaitVarException;

    @Override
    default public boolean entailsValueOrIdent(ValueOrIdent operand, Env env) throws WaitVarException {
        return this.entails(operand.resolveValue(env), null);
    }

    @Override
    default public boolean entailsValueOrVar(ValueOrVar operand, Set<Memo> memos) throws WaitVarException {
        return operand.entails(this, memos);
    }

    @Override
    default public boolean entailsVar(Var operand, Set<Memo> memos) throws WaitVarException {
        return operand.entails(this, memos);
    }

    default public Bool greaterThan(Value operand) {
        throw new UnsupportedOperationException("> not supported");
    }

    default public Bool greaterThanOrEqualTo(Value operand) {
        throw new UnsupportedOperationException(">= not supported");
    }

    default public boolean isValidKey() {
        return false;
    }

    default public Bool lessThan(Value operand) {
        throw new UnsupportedOperationException("< not supported");
    }

    default public Bool lessThanOrEqualTo(Value operand) {
        throw new UnsupportedOperationException("<= not supported");
    }

    default public Value modulo(Value divisor) {
        throw new UnsupportedOperationException("% not supported");
    }

    default public Value multiply(Value multiplicand) {
        throw new UnsupportedOperationException("* not supported");
    }

    default public Value negate() {
        throw new UnsupportedOperationException("Negate not supported");
    }

    default public Value not() {
        throw new UnsupportedOperationException("! not supported");
    }

    @Override
    default public Value resolveValue(Env env) {
        return this;
    }

    @Override
    default public Value resolveValue() {
        return this;
    }

    @Override
    default public ValueOrIdent resolveValueOrIdent(Env env) {
        return this;
    }

    @Override
    default public ValueOrVar resolveValueOrVar(Env env) {
        return this;
    }

    @Override
    default public ValueOrVar resolveValueOrVar() {
        return this;
    }

    default public Value subtract(Value subtrahend) {
        throw new UnsupportedOperationException("Subtract not supported");
    }

    default public Rec unifyRecs(Rec rec, Set<Memo> memos) throws WaitVarException {
        throw new UnificationError(this, rec);
    }
}

