/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.List;
import org.torqlang.klvm.CommonFeatures;
import org.torqlang.klvm.CompleteOrIdent;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.Ident;
import org.torqlang.klvm.InvalidArgCountError;
import org.torqlang.klvm.KernelModule;
import org.torqlang.klvm.Machine;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueIterSource;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.WaitException;

public final class ValueIterMod
implements KernelModule {
    public static final Str VALUE_ITER_STR = Str.of("ValueIter");
    public static final Ident VALUE_ITER_IDENT = Ident.create(ValueIterMod.VALUE_ITER_STR.value);
    private final CompleteRec namesake = Rec.completeRecBuilder().addField(CommonFeatures.$NEW, ValueIterMod::clsNew).build();
    private final CompleteRec exports = Rec.completeRecBuilder().addField(VALUE_ITER_STR, this.namesake).build();

    private ValueIterMod() {
    }

    public static ValueIterMod singleton() {
        return LazySingleton.SINGLETON;
    }

    static void clsNew(List<CompleteOrIdent> ys, Env env, Machine machine) throws WaitException {
        int expectedArgCount = 2;
        if (ys.size() != 2) {
            throw new InvalidArgCountError(2, ys, "ValueIter.new");
        }
        Value source = ys.get(0).resolveValue(env);
        if (!(source instanceof ValueIterSource)) {
            throw new IllegalArgumentException(String.valueOf(ys.get(0)) + " must be a type of " + ValueIterSource.class.getSimpleName());
        }
        ValueIterSource iterable = (ValueIterSource)((Object)source);
        ValueOrVar iter = iterable.valueIter();
        ValueOrVar target = ys.get(1).resolveValueOrVar(env);
        target.bindToValueOrVar(iter, null);
    }

    @Override
    public final CompleteRec exports() {
        return this.exports;
    }

    @Override
    public final CompleteRec namesake() {
        return this.namesake;
    }

    @Override
    public final Ident namesakeIdent() {
        return VALUE_ITER_IDENT;
    }

    private static final class LazySingleton {
        private static final ValueIterMod SINGLETON = new ValueIterMod();

        private LazySingleton() {
        }
    }
}

