/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Set;
import org.torqlang.klvm.BindCallback;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.Env;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.LiteralOrVar;
import org.torqlang.klvm.Memo;
import org.torqlang.klvm.Value;
import org.torqlang.klvm.ValueOrIdent;
import org.torqlang.klvm.ValueOrVar;
import org.torqlang.klvm.ValueOrVarSet;
import org.torqlang.klvm.VarSet;
import org.torqlang.klvm.WaitVarException;

public final class Var
implements LiteralOrVar {
    private ValueOrVarSet valueOrVarSet;
    private BindCallback bindCallback;

    public Var(ValueOrVarSet valueOrVarSet) {
        this.valueOrVarSet = valueOrVarSet;
    }

    public Var() {
        this(VarSet.EMPTY_VAR_SET);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitVar(this, state);
    }

    public final BindCallback bindCallback() {
        return this.bindCallback;
    }

    @Override
    public final Value bindToValue(Value value, Set<Memo> memos) throws WaitVarException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.valueOrVarSet == VarSet.EMPTY_VAR_SET) {
            this.valueOrVarSet = value;
            if (this.bindCallback != null) {
                this.bindCallback.onBound(this, value);
            }
            return value;
        }
        ValueOrVarSet valueOrVarSet = this.valueOrVarSet;
        if (valueOrVarSet instanceof VarSet) {
            VarSet thisVarSet = (VarSet)valueOrVarSet;
            for (Var varElem : thisVarSet) {
                varElem.valueOrVarSet = value;
                if (varElem.bindCallback == null) continue;
                varElem.bindCallback.onBound(this, value);
            }
            return value;
        }
        this.valueOrVarSet = ((Value)this.valueOrVarSet).bindToValue(value, memos);
        return (Value)this.valueOrVarSet;
    }

    @Override
    public final ValueOrVar bindToValueOrVar(ValueOrVar valueOrVar, Set<Memo> memos) throws WaitVarException {
        return valueOrVar.bindToVar(this, memos);
    }

    @Override
    public final ValueOrVar bindToVar(Var other, Set<Memo> memos) throws WaitVarException {
        Object object = other.valueOrVarSet;
        if (object instanceof Value) {
            Value otherValue = (Value)object;
            Value unifiedValue = this.bindToValue(otherValue, memos);
            if (otherValue != unifiedValue) {
                other.valueOrVarSet = unifiedValue;
            }
            return unifiedValue;
        }
        object = this.valueOrVarSet;
        if (object instanceof Value) {
            Value thisValue = (Value)object;
            other.bindToValue(thisValue, memos);
            return thisValue;
        }
        if (this.valueOrVarSet == VarSet.EMPTY_VAR_SET) {
            if (other.valueOrVarSet == VarSet.EMPTY_VAR_SET) {
                VarSet pair = VarSet.createPrivatelyForKlvm(new Var[]{this, other}, 2);
                this.valueOrVarSet = pair;
                other.valueOrVarSet = pair;
            } else {
                VarSet plusOne = ((VarSet)other.valueOrVarSet).add(this);
                for (Var v : plusOne) {
                    v.valueOrVarSet = plusOne;
                }
            }
        } else if (other.valueOrVarSet == VarSet.EMPTY_VAR_SET) {
            VarSet plusOne = ((VarSet)this.valueOrVarSet).add(other);
            for (Var v : plusOne) {
                v.valueOrVarSet = plusOne;
            }
        } else {
            VarSet union = VarSet.union((VarSet)this.valueOrVarSet, (VarSet)other.valueOrVarSet);
            for (Var v : union) {
                v.valueOrVarSet = union;
            }
        }
        return this;
    }

    @Override
    public final Complete checkComplete() throws WaitVarException {
        throw new WaitVarException(this);
    }

    @Override
    public final boolean entails(Value operand, Set<Memo> memos) throws WaitVarException {
        ValueOrVarSet valueOrVarSet = this.valueOrVarSet;
        if (valueOrVarSet instanceof Value) {
            Value thisValue = (Value)valueOrVarSet;
            return thisValue.entails(operand, memos);
        }
        throw new WaitVarException(this);
    }

    @Override
    public final boolean entailsValueOrIdent(ValueOrIdent operand, Env env) throws WaitVarException {
        return this.entailsValueOrVar(operand.resolveValueOrVar(env), null);
    }

    @Override
    public final boolean entailsValueOrVar(ValueOrVar operand, Set<Memo> memos) throws WaitVarException {
        return operand.entailsVar(this, memos);
    }

    @Override
    public final boolean entailsVar(Var operand, Set<Memo> memos) throws WaitVarException {
        if (this == operand) {
            return true;
        }
        if (this.valueOrVarSet == VarSet.EMPTY_VAR_SET || operand.valueOrVarSet == VarSet.EMPTY_VAR_SET) {
            throw new WaitVarException(this);
        }
        if (this.valueOrVarSet == operand.valueOrVarSet) {
            return true;
        }
        ValueOrVarSet valueOrVarSet = operand.valueOrVarSet;
        if (valueOrVarSet instanceof Value) {
            Value operandValue = (Value)valueOrVarSet;
            return this.entails(operandValue, memos);
        }
        valueOrVarSet = this.valueOrVarSet;
        if (valueOrVarSet instanceof Value) {
            Value thisValue = (Value)valueOrVarSet;
            return operand.entails(thisValue, memos);
        }
        throw new WaitVarException(this);
    }

    public final String formatValue() {
        return "<<$var " + Integer.toHexString(System.identityHashCode(this)) + ">>";
    }

    @Override
    public final Value resolveValue() throws WaitVarException {
        ValueOrVarSet valueOrVarSet = this.valueOrVarSet;
        if (valueOrVarSet instanceof Value) {
            Value thisValue = (Value)valueOrVarSet;
            return thisValue.checkNotFailedValue();
        }
        throw new WaitVarException(this);
    }

    @Override
    public final ValueOrVar resolveValueOrVar() {
        ValueOrVar valueOrVar;
        ValueOrVarSet valueOrVarSet = this.valueOrVarSet;
        if (valueOrVarSet instanceof Value) {
            Value thisValue = (Value)valueOrVarSet;
            valueOrVar = thisValue.checkNotFailedValue();
        } else {
            valueOrVar = this;
        }
        return valueOrVar;
    }

    public final void setBindCallback(BindCallback bindCallback) {
        this.bindCallback = bindCallback;
    }

    public final String toString() {
        return this.formatValue();
    }

    public final ValueOrVarSet valueOrVarSet() {
        return this.valueOrVarSet;
    }
}

