/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.klvm;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.torqlang.klvm.KernelVisitor;
import org.torqlang.klvm.ValueOrVarSet;
import org.torqlang.klvm.Var;

public final class VarSet
implements ValueOrVarSet,
Iterable<Var> {
    public static final VarSet EMPTY_VAR_SET = new VarSet(new Var[0], 0);
    private final Var[] vars;
    private final int size;

    private VarSet(Var[] vars, int size) {
        this.vars = vars;
        this.size = size;
    }

    private static boolean contains(Var[] vars, int size, Var var) {
        for (int i = 0; i < size; ++i) {
            if (vars[i] != var) continue;
            return true;
        }
        return false;
    }

    static VarSet createPrivatelyForKlvm(Var[] vars, int size) {
        return new VarSet(vars, size);
    }

    public static VarSet union(VarSet es1, VarSet es2) {
        if (es1 == es2) {
            return es1;
        }
        Var[] vs = new Var[es1.size() + es2.size()];
        int size = 0;
        for (Var v : es1) {
            if (VarSet.contains(vs, size, v)) continue;
            vs[size] = v;
            ++size;
        }
        for (Var v : es2) {
            if (VarSet.contains(vs, size, v)) continue;
            vs[size] = v;
            ++size;
        }
        return new VarSet(vs, size);
    }

    @Override
    public final <T, R> R accept(KernelVisitor<T, R> visitor, T state) {
        return visitor.visitVarSet(this, state);
    }

    public VarSet add(Var var) {
        if (VarSet.contains(this.vars, this.size, var)) {
            return this;
        }
        int newSize = this.size + 1;
        Var[] newVars = new Var[newSize];
        System.arraycopy(this.vars, 0, newVars, 0, this.size);
        newVars[this.size] = var;
        return new VarSet(newVars, newSize);
    }

    public final boolean contains(Var var) {
        return VarSet.contains(this.vars, this.size, var);
    }

    public final String formatValue() {
        StringBuilder sb = new StringBuilder();
        if (this == EMPTY_VAR_SET) {
            sb.append("<<$var_set>>");
        } else {
            sb.append("<<$var_set ");
            Iterator<Var> iter = this.iterator();
            while (iter.hasNext()) {
                Var var = iter.next();
                sb.append(var.toString());
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(">>");
        }
        return sb.toString();
    }

    @Override
    public final Iterator<Var> iterator() {
        return new VarSetIterator();
    }

    public final int size() {
        return this.size;
    }

    public final String toString() {
        return this.formatValue();
    }

    private final class VarSetIterator
    implements Iterator<Var> {
        private int index = 0;

        private VarSetIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.index < VarSet.this.size;
        }

        @Override
        public final Var next() {
            if (this.index < VarSet.this.size) {
                return VarSet.this.vars[this.index++];
            }
            throw new NoSuchElementException("Next element is not present");
        }
    }
}

