/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.CompleteTuple;
import org.torqlang.klvm.FailedValue;
import org.torqlang.klvm.Null;
import org.torqlang.local.Actor;
import org.torqlang.local.ActorImage;
import org.torqlang.local.ActorRef;
import org.torqlang.local.ActorSystem;
import org.torqlang.local.Address;
import org.torqlang.local.Envelope;
import org.torqlang.server.ApiHandlerBuilder;
import org.torqlang.server.ApiPath;
import org.torqlang.server.ApiRoute;
import org.torqlang.server.ApiRouter;
import org.torqlang.server.ApiTarget;

public final class ApiHandler
extends Handler.Abstract.NonBlocking {
    private static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";
    private static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain; charset=utf-8";
    private static final String RESPONSE_ADDRESS_PREFIX = "ApiHandler.ResponseAddress";
    private final ActorSystem system;
    private final ApiRouter router;

    public ApiHandler(ActorSystem system, ApiRouter router) {
        this.system = system;
        this.router = router;
    }

    public static ApiHandlerBuilder builder() {
        return new ApiHandlerBuilder();
    }

    public final boolean handle(Request request, Response response, Callback callback) {
        String method = request.getMethod();
        String pathInContext = URLDecoder.decode(Request.getPathInContext((Request)request), StandardCharsets.UTF_8);
        ApiPath path = ApiPath.parse(pathInContext);
        ApiRoute route = this.router.findRoute(path);
        if (route == null) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)404);
            return true;
        }
        if (route.rateLimiter != null && route.rateLimiter.rateExceeded()) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)429);
            return true;
        }
        CompleteTuple pathTuple = route.desc.toPathTuple(path);
        CompleteRec headersRec = route.desc.toHeadersRec(request.getHeaders());
        CompleteRec queryRec = route.desc.toQueryRec(Request.extractQueryParameters((Request)request));
        CompleteRec contextRec = route.desc.toContextRec(request);
        if (method.equals(HttpMethod.GET.name())) {
            this.sendRequestMessage(request, response, callback, route, headersRec, method, pathTuple, queryRec, contextRec, null);
        } else {
            Content.Source.asStringAsync((Content.Source)request, (Charset)StandardCharsets.UTF_8).thenAccept(requestText -> this.sendRequestMessage(request, response, callback, route, headersRec, method, pathTuple, queryRec, contextRec, (String)requestText));
        }
        return true;
    }

    public final ApiRouter router() {
        return this.router;
    }

    private void sendRequestMessage(Request request, Response response, Callback callback, ApiRoute route, CompleteRec headersRec, String method, CompleteTuple pathTuple, CompleteRec queryRec, CompleteRec contextRec, String requestText) {
        try {
            ActorRef actorRef;
            ApiTarget apiTarget = route.target;
            if (apiTarget instanceof ApiTarget.ApiTargetImage) {
                ApiTarget.ApiTargetImage targetImage = (ApiTarget.ApiTargetImage)apiTarget;
                actorRef = Actor.spawn((Address)targetImage.address, (ActorImage)targetImage.value());
            } else {
                actorRef = ((ApiTarget.ApiTargetRef)route.target).actorRef;
            }
            CompleteRec requestRec = route.desc.toRequestRec(method, pathTuple, headersRec, queryRec, contextRec, requestText);
            ResponseAdapter responseAdapter = new ResponseAdapter(request, response, callback, route);
            actorRef.send(Envelope.createRequest((Object)requestRec, (ActorRef)responseAdapter, (Object)Null.SINGLETON));
        }
        catch (Exception exc) {
            Response.writeError((Request)request, (Response)response, (Callback)callback, (Throwable)exc);
        }
    }

    public final ActorSystem system() {
        return this.system;
    }

    private static class ResponseAdapter
    implements ActorRef {
        private final Address address;
        private final Request request;
        private final Response response;
        private final Callback callback;
        private final ApiRoute route;

        private ResponseAdapter(Request request, Response response, Callback callback, ApiRoute route) {
            this.address = Address.create((String)("ApiHandler.ResponseAddress." + request.getId()));
            this.request = request;
            this.response = response;
            this.callback = callback;
            this.route = route;
        }

        public Address address() {
            return this.address;
        }

        public void send(Envelope envelope) {
            try {
                Complete message = (Complete)envelope.message();
                if (!envelope.isResponse()) {
                    this.response.setStatus(500);
                    this.response.getHeaders().put(HttpHeader.CONTENT_TYPE, ApiHandler.TEXT_PLAIN_CHARSET_UTF_8);
                    Content.Sink.write((Content.Sink)this.response, (boolean)true, (String)("Not a response: " + String.valueOf(envelope)), (Callback)this.callback);
                } else if (message instanceof FailedValue) {
                    FailedValue failedValue = (FailedValue)message;
                    this.response.setStatus(500);
                    this.response.getHeaders().put(HttpHeader.CONTENT_TYPE, ApiHandler.TEXT_PLAIN_CHARSET_UTF_8);
                    Content.Sink.write((Content.Sink)this.response, (boolean)true, (String)failedValue.toDetailsString(), (Callback)this.callback);
                } else {
                    String bodyText = this.route.desc.toResponseBodyText(message);
                    this.response.setStatus(200);
                    this.response.getHeaders().put(HttpHeader.CONTENT_TYPE, ApiHandler.APPLICATION_JSON_CHARSET_UTF_8);
                    Content.Sink.write((Content.Sink)this.response, (boolean)true, (String)bodyText, (Callback)this.callback);
                }
            }
            catch (Exception exc) {
                Response.writeError((Request)this.request, (Response)this.response, (Callback)this.callback, (Throwable)exc);
            }
        }
    }
}

