/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import java.util.ArrayList;
import java.util.List;
import org.torqlang.server.ApiPathParam;

public final class ApiPath
implements Comparable<ApiPath> {
    public final List<String> segs;

    private ApiPath(List<String> segs) {
        this.segs = segs;
    }

    public static ApiPath parse(String path) {
        List<String> segs;
        if (path.equals("/")) {
            segs = List.of();
        } else {
            if (path.isEmpty() || path.charAt(0) != '/') {
                throw new IllegalArgumentException("Does not begin with a '/': " + path);
            }
            if (path.charAt(path.length() - 1) == '/') {
                throw new IllegalArgumentException("Cannot end with a '/': " + path);
            }
            List<String> segsParsed = List.of(path.split("/"));
            segs = segsParsed.subList(1, segsParsed.size());
        }
        return new ApiPath(segs);
    }

    private static int compareSeg(String seg, String targetSeg) {
        if (ApiPath.isWildcard(seg)) {
            return 0;
        }
        if (ApiPath.isWildcard(targetSeg)) {
            return 0;
        }
        return seg.compareTo(targetSeg);
    }

    private static boolean isWildcard(String seg) {
        char firstChar = seg.charAt(0);
        if (firstChar == '{') {
            char lastChar = seg.charAt(seg.length() - 1);
            return lastChar == '}';
        }
        return false;
    }

    public final int compareSegs(List<String> targetSegs) {
        for (int i = 0; i < this.segs.size(); ++i) {
            int compare;
            if (i >= targetSegs.size() || (compare = ApiPath.compareSeg(this.segs.get(i), targetSegs.get(i))) == 0) continue;
            return compare;
        }
        return Integer.compare(this.segs.size(), targetSegs.size());
    }

    @Override
    public final int compareTo(ApiPath apiPath) {
        return this.compareSegs(apiPath.segs);
    }

    public final List<ApiPathParam> extractParams() {
        ArrayList<ApiPathParam> params = new ArrayList<ApiPathParam>();
        for (int i = 0; i < this.segs.size(); ++i) {
            String seg = this.segs.get(i);
            if (!ApiPath.isWildcard(seg)) continue;
            params.add(new ApiPathParam(i, seg.substring(1, seg.length() - 1)));
        }
        return params;
    }
}

