/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import org.torqlang.local.ActorImage;
import org.torqlang.local.ActorRef;
import org.torqlang.local.Address;
import org.torqlang.server.ApiDesc;
import org.torqlang.server.ApiPath;
import org.torqlang.server.ApiTarget;
import org.torqlang.server.RateLimiter;

public final class ApiRoute {
    public final ApiPath path;
    public final ApiTarget target;
    public final ApiDesc desc;
    public final RateLimiter rateLimiter;

    public ApiRoute(ApiPath path, ApiTarget target, ApiDesc desc, RateLimiter rateLimiter) {
        this.path = path;
        this.target = target;
        this.desc = desc;
        this.rateLimiter = rateLimiter;
    }

    public static ApiRoute create(ApiPath path, ActorImage actorImage, ApiDesc desc) {
        return new ApiRoute(path, ApiTarget.create(ApiRoute.toAddress(path), actorImage), desc, null);
    }

    public static ApiRoute create(ApiPath path, ActorImage actorImage, ApiDesc desc, RateLimiter rateLimiter) {
        return new ApiRoute(path, ApiTarget.create(ApiRoute.toAddress(path), actorImage), desc, rateLimiter);
    }

    public static ApiRoute create(ApiPath path, ActorRef actorRef, ApiDesc desc) {
        return new ApiRoute(path, ApiTarget.create(actorRef), desc, null);
    }

    public static ApiRoute create(ApiPath path, ActorRef actorRef, ApiDesc desc, RateLimiter rateLimiter) {
        return new ApiRoute(path, ApiTarget.create(actorRef), desc, rateLimiter);
    }

    public static Address toAddress(ApiPath path) {
        return Address.create((String)String.join((CharSequence)"/", path.segs));
    }
}

