/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.torqlang.klvm.Complete;
import org.torqlang.klvm.CompleteRec;
import org.torqlang.klvm.CompleteRecBuilder;
import org.torqlang.klvm.CompleteTuple;
import org.torqlang.klvm.CompleteTupleBuilder;
import org.torqlang.klvm.Feature;
import org.torqlang.klvm.Literal;
import org.torqlang.klvm.Null;
import org.torqlang.klvm.Rec;
import org.torqlang.klvm.Str;
import org.torqlang.lang.FeatureAsType;
import org.torqlang.lang.Json;
import org.torqlang.lang.JsonParser;
import org.torqlang.lang.RecType;
import org.torqlang.lang.RecTypeExpr;
import org.torqlang.lang.TupleType;
import org.torqlang.lang.TupleTypeExpr;
import org.torqlang.lang.Type;
import org.torqlang.local.ValueTools;
import org.torqlang.server.ApiDesc;
import org.torqlang.server.ApiPath;
import org.torqlang.server.ContextProvider;

final class DefaultApiDesc
implements ApiDesc {
    private final Type inputType;
    private final Type outputType;
    private final TupleType pathType;
    private final RecType queryType;
    private final ContextProvider contextProvider;

    DefaultApiDesc(TupleType pathType, RecType queryType, Type inputType, Type outputDesc, ContextProvider contextProvider) {
        this.pathType = pathType;
        this.queryType = queryType;
        this.inputType = inputType;
        this.outputType = outputDesc;
        this.contextProvider = contextProvider;
    }

    @Override
    public final Type inputType() {
        return this.inputType;
    }

    @Override
    public final Type outputType() {
        return this.outputType;
    }

    @Override
    public final TupleType pathType() {
        return this.pathType;
    }

    @Override
    public final RecType queryType() {
        return this.queryType;
    }

    @Override
    public final CompleteRec toContextRec(Request request) {
        return this.contextProvider.apply(request);
    }

    @Override
    public final CompleteRec toHeadersRec(HttpFields headerFields) {
        CompleteRecBuilder headersRecBuilder = Rec.completeRecBuilder();
        for (HttpField f : headerFields) {
            headersRecBuilder.addField((Feature)Str.of((String)f.getName()), (Complete)Str.of((String)f.getValue()));
        }
        return headersRecBuilder.build();
    }

    @Override
    public final CompleteTuple toPathTuple(ApiPath path) {
        if (this.pathType == null) {
            throw new IllegalArgumentException("Path description is null");
        }
        TupleTypeExpr pathTypeExpr = null;
        TupleType tupleType = this.pathType;
        if (tupleType instanceof TupleTypeExpr) {
            TupleTypeExpr pathTypeExprFound;
            pathTypeExpr = pathTypeExprFound = (TupleTypeExpr)tupleType;
            if (path.segs.size() != pathTypeExpr.values.size()) {
                throw new IllegalArgumentException("Path size does not match API description");
            }
        }
        CompleteTupleBuilder tupleBuilder = Rec.completeTupleBuilder();
        for (int i = 0; i < path.segs.size(); ++i) {
            String seg = path.segs.get(i);
            Type segType = pathTypeExpr != null ? (Type)pathTypeExpr.values.get(i) : null;
            tupleBuilder.addValue(ValueTools.toKernelValue((Object)seg, (Type)segType));
        }
        return tupleBuilder.build();
    }

    @Override
    public final CompleteRec toQueryRec(Fields queryFields) {
        CompleteRecBuilder queryRecBuilder = Rec.completeRecBuilder();
        for (Fields.Field f : queryFields) {
            FeatureAsType featureAsType;
            RecTypeExpr queryTypeExpr;
            Type queryValueType;
            RecType recType;
            Str feature = Str.of((String)f.getName());
            String queryValue = f.getValue();
            if (queryValue.charAt(0) == '\"') {
                queryValue = queryValue.substring(1, queryValue.length() - 1);
                queryValue = queryValue.replace("\\\"", "\"");
            }
            Object value = (recType = this.queryType) instanceof RecTypeExpr ? ((queryValueType = (queryTypeExpr = (RecTypeExpr)recType).findValue(featureAsType = FeatureAsType.create((Feature)feature))) != null ? ValueTools.toKernelValue((Object)queryValue, (Type)queryValueType) : Str.of((String)queryValue)) : Str.of((String)queryValue);
            queryRecBuilder.addField((Feature)feature, (Complete)value);
        }
        return queryRecBuilder.build();
    }

    @Override
    public final CompleteRec toRequestRec(String method, CompleteTuple pathTuple, CompleteRec headersRec, CompleteRec queryRec, CompleteRec contextRec, String requestText) {
        CompleteRecBuilder requestRecBuilder = Rec.completeRecBuilder().setLabel((Literal)Str.of((String)method)).addField((Feature)Str.of((String)"headers"), (Complete)headersRec).addField((Feature)Str.of((String)"path"), (Complete)pathTuple).addField((Feature)Str.of((String)"query"), (Complete)queryRec);
        if (requestText != null) {
            Object bodyValue = requestText.isBlank() ? Null.SINGLETON : ValueTools.toKernelValue((Object)new JsonParser(requestText).parse(), (Type)this.inputType);
            requestRecBuilder.addField((Feature)Str.of((String)"body"), (Complete)bodyValue);
        }
        requestRecBuilder.addField((Feature)Str.of((String)"context"), (Complete)contextRec);
        return requestRecBuilder.build();
    }

    @Override
    public String toResponseBodyText(Complete response) {
        Object nativeResponseValue = ValueTools.toNativeValue((Complete)response);
        return Json.format((Object)nativeResponseValue);
    }
}

