/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

public final class EchoHandler
extends Handler.Abstract.NonBlocking {
    private static String formatHeaderFields(HttpFields httpFields) {
        if (httpFields == null) {
            return "  (none)";
        }
        Iterator it = httpFields.stream().iterator();
        if (!it.hasNext()) {
            return "  (none)";
        }
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            HttpField f = (HttpField)it.next();
            sb.append("  ").append(f.getName()).append(": ").append(f.getValue());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String formatQueryFields(Fields fields) {
        if (fields == null) {
            return "  (none)";
        }
        Iterator it = fields.stream().iterator();
        if (!it.hasNext()) {
            return "  (none)";
        }
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Fields.Field f = (Fields.Field)it.next();
            sb.append("  ").append(f.getName()).append(": ").append(f.getValue());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public final boolean handle(Request request, Response response, Callback callback) {
        Content.Source.asStringAsync((Content.Source)request, (Charset)StandardCharsets.UTF_8).thenAccept(s -> this.onContentComplete((String)s, request, response, callback));
        return true;
    }

    private void onContentComplete(String content, Request request, Response response, Callback callback) {
        StringBuilder sb = new StringBuilder();
        sb.append("request.getId() = ").append(request.getId()).append('\n');
        sb.append("request.getMethod() = ").append(request.getMethod()).append('\n');
        sb.append("request.getHttpURI() = ").append(request.getHttpURI()).append('\n');
        sb.append("request.getHttpURI().getPath() = ").append(request.getHttpURI().getPath()).append('\n');
        sb.append("request.getHttpURI().getQuery() = ").append(request.getHttpURI().getQuery()).append('\n');
        sb.append("request.getHttpURI().getPathQuery() = ").append(request.getHttpURI().getPathQuery()).append('\n');
        sb.append("URLDecoder.decode(request.getHttpURI().getPathQuery(), StandardCharsets.UTF_8) = ").append(URLDecoder.decode(request.getHttpURI().getPathQuery(), StandardCharsets.UTF_8)).append('\n');
        sb.append("Request.getPathInContext(request) = ").append(Request.getPathInContext((Request)request)).append('\n');
        sb.append("Request.extractQueryParameters(request) {").append('\n').append(EchoHandler.formatQueryFields(Request.extractQueryParameters((Request)request))).append('\n').append("}").append('\n');
        sb.append("request.getHeaders() {").append('\n').append(EchoHandler.formatHeaderFields(request.getHeaders())).append('\n').append("}").append('\n');
        sb.append("request.getTrailers() {").append('\n').append(EchoHandler.formatHeaderFields(request.getTrailers())).append('\n').append("}").append('\n');
        sb.append("request.getLength() = ").append(request.getLength()).append('\n');
        sb.append("Content.Source.asStringAsync(request, StandardCharsets.UTF_8) = ").append(content.isEmpty() ? "(empty)" : content).append('\n');
        response.setStatus(200);
        response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/plain; charset=utf-8");
        Content.Sink.write((Content.Sink)response, (boolean)true, (String)sb.toString(), (Callback)callback);
    }
}

