/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.torqlang.server.LocalServerBuilder;
import org.torqlang.util.ConsoleLogger;

public class LocalServer {
    private static final ConsoleLogger LOGGER = ConsoleLogger.SINGLETON;
    private final Server server;
    private final int port;

    public LocalServer(Server server, int port) {
        this.server = server;
        this.port = port;
    }

    public static LocalServerBuilder builder() {
        return new LocalServerBuilder();
    }

    public final void join() throws InterruptedException {
        this.server.join();
    }

    public final void start() throws Exception {
        LOGGER.info("Starting server on port " + this.port);
        this.server.start();
        LOGGER.info("Done starting server");
        LOGGER.info("  Port: " + this.port);
        LOGGER.info("  Invocation type: " + String.valueOf(this.server.getInvocationType()));
        for (Connector c : this.server.getConnectors()) {
            ServerConnector sc = (ServerConnector)c;
            LOGGER.info("  Connector: " + sc.getClass().getName());
            LOGGER.info("    Acceptors: " + sc.getAcceptors());
            LOGGER.info("    Selectors: " + sc.getSelectorManager().getSelectorCount());
            LOGGER.info("    Accept queue size: " + sc.getAcceptQueueSize());
        }
    }

    public final void stop() throws Exception {
        this.server.stop();
    }
}

