/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.torqlang.server.LocalServer;

public final class LocalServerBuilder {
    private int port;
    private final ContextHandlerCollection contextHandlers = new ContextHandlerCollection(false, new ContextHandler[0]);

    LocalServerBuilder() {
    }

    public final LocalServerBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public final int port() {
        return this.port;
    }

    public final LocalServerBuilder addContextHandler(Handler handler, String contextPath) {
        ContextHandler contextHandler = new ContextHandler(handler, contextPath);
        this.contextHandlers.addHandler((Handler)contextHandler);
        return this;
    }

    public LocalServer build() {
        Server server = new Server(this.port);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http11, http2c});
        server.addConnector((Connector)connector);
        server.setHandler((Handler)this.contextHandlers);
        return new LocalServer(server, this.port);
    }
}

