/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

public final class RateLimiter {
    private static final long ONE_SECOND = 1000L;
    private final Object lock = new Object();
    private final int limit;
    private volatile long startTime;
    private volatile int remaining;

    private RateLimiter(int limit) {
        this.limit = limit;
        this.startTime = System.currentTimeMillis();
        this.remaining = limit;
    }

    public static RateLimiter create(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit <= 0");
        }
        return new RateLimiter(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean rateExceeded() {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long elapsedTime = now - this.startTime;
            if (elapsedTime > 1000L) {
                this.startTime = now;
                this.remaining = this.limit;
                return false;
            }
            if (this.remaining > 0) {
                --this.remaining;
                return false;
            }
            return true;
        }
    }
}

