/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.torqlang.server.ApiPath;
import org.torqlang.server.ApiRoute;
import org.torqlang.server.ApiRouter;
import org.torqlang.util.BinarySearchTools;

final class StaticApiRouter
implements ApiRouter {
    private final ApiRoute[] routesByPath;

    StaticApiRouter(List<ApiRoute> routes) {
        this.routesByPath = routes.toArray(new ApiRoute[0]);
        Arrays.sort(this.routesByPath, Comparator.comparing(r -> r.path));
    }

    @Override
    public final ApiRoute findRoute(ApiPath path) {
        int index = BinarySearchTools.search((Object[])this.routesByPath, r -> path.compareTo(r.path));
        if (index < 0) {
            return null;
        }
        return this.routesByPath[index];
    }
}

