/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.server;

import java.util.ArrayList;
import java.util.List;
import org.torqlang.local.ActorImage;
import org.torqlang.local.ActorRef;
import org.torqlang.server.ApiDesc;
import org.torqlang.server.ApiPath;
import org.torqlang.server.ApiRoute;
import org.torqlang.server.ApiRouter;
import org.torqlang.server.RateLimiter;
import org.torqlang.server.StaticApiRouter;

public final class StaticApiRouterBuilder {
    private final List<ApiRoute> routes = new ArrayList<ApiRoute>();

    public final StaticApiRouterBuilder addRoute(String pathExpr, ActorImage actorImage, ApiDesc desc) {
        ApiPath path = ApiPath.parse(pathExpr);
        this.routes.add(ApiRoute.create(path, actorImage, desc));
        return this;
    }

    public final StaticApiRouterBuilder addRoute(String pathExpr, ActorImage actorImage, ApiDesc desc, RateLimiter rateLimiter) {
        ApiPath path = ApiPath.parse(pathExpr);
        this.routes.add(ApiRoute.create(path, actorImage, desc, rateLimiter));
        return this;
    }

    public final StaticApiRouterBuilder addRoute(String pathExpr, ActorRef actorRef, ApiDesc desc) {
        ApiPath path = ApiPath.parse(pathExpr);
        this.routes.add(ApiRoute.create(path, actorRef, desc));
        return this;
    }

    public final StaticApiRouterBuilder addRoute(String pathExpr, ActorRef actorRef, ApiDesc desc, RateLimiter rateLimiter) {
        ApiPath path = ApiPath.parse(pathExpr);
        this.routes.add(ApiRoute.create(path, actorRef, desc, rateLimiter));
        return this;
    }

    public final ApiRouter build() {
        return new StaticApiRouter(this.routes);
    }
}

