/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

import java.util.List;
import java.util.Objects;
import org.torqlang.util.Logger;
import org.torqlang.util.LoggerTools;
import org.torqlang.util.MessageLevel;

public final class ConsoleLogger
implements Logger {
    public static final ConsoleLogger SINGLETON = new ConsoleLogger();

    private ConsoleLogger() {
    }

    @Override
    public void debug(String message) {
        if (LoggerTools.isLogging(MessageLevel.DEBUG)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.DEBUG.name(), null, message));
        }
    }

    @Override
    public void debug(String caller, String message) {
        if (LoggerTools.isLogging(MessageLevel.DEBUG)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.DEBUG.name(), caller, message));
        }
    }

    @Override
    public void error(String message) {
        if (LoggerTools.isLogging(MessageLevel.ERROR)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.ERROR.name(), null, message));
        }
    }

    @Override
    public void error(String caller, String message) {
        if (LoggerTools.isLogging(MessageLevel.ERROR)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.ERROR.name(), caller, message));
        }
    }

    @Override
    public void info(String message) {
        if (LoggerTools.isLogging(MessageLevel.INFO)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.INFO.name(), null, message));
        }
    }

    @Override
    public void info(String caller, String message) {
        if (LoggerTools.isLogging(MessageLevel.INFO)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.INFO.name(), caller, message));
        }
    }

    @Override
    public void log(String formattedMessage) {
        System.out.println(formattedMessage);
    }

    @Override
    public void logAll(List<String> formattedMessages) {
        Objects.requireNonNull(formattedMessages);
        for (String message : formattedMessages) {
            this.log(message);
        }
    }

    @Override
    public void trace(String message) {
        if (LoggerTools.isLogging(MessageLevel.TRACE)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.TRACE.name(), null, message));
        }
    }

    @Override
    public void trace(String caller, String message) {
        if (LoggerTools.isLogging(MessageLevel.TRACE)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.TRACE.name(), caller, message));
        }
    }

    @Override
    public void warn(String message) {
        if (LoggerTools.isLogging(MessageLevel.WARN)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.WARN.name(), null, message));
        }
    }

    @Override
    public void warn(String caller, String message) {
        if (LoggerTools.isLogging(MessageLevel.WARN)) {
            this.log(LoggerTools.formatter().apply(MessageLevel.WARN.name(), caller, message));
        }
    }
}

