/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

import java.io.IOException;
import java.io.Writer;
import org.torqlang.util.FormatterError;

public class FormatterState {
    public static final int INLINE_VALUE = -1;
    public static final char NEWLINE = '\n';
    public static final char SPACE = ' ';
    private static final int INDENT_SIZE = 4;
    private final int level;
    private final Writer writer;

    public FormatterState(Writer writer) {
        this(writer, 0);
    }

    private FormatterState(Writer writer, int level) {
        this.writer = writer;
        this.level = level;
    }

    public final void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException exc) {
            throw new FormatterError("Cannot flush writer", exc);
        }
    }

    public final FormatterState inline() {
        return this.level == -1 ? this : new FormatterState(this.writer, -1);
    }

    public final int level() {
        return this.level;
    }

    public final FormatterState nextLevel() {
        return this.level == -1 ? this : new FormatterState(this.writer, this.level + 1);
    }

    public final void write(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException exc) {
            throw new FormatterError("Cannot write character", exc);
        }
    }

    public final void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException exc) {
            throw new FormatterError("Cannot write string", exc);
        }
    }

    public final void writeAfterNewLineAndIdent(String s) {
        this.writeNewLine();
        this.writeIndent();
        this.write(s);
    }

    public final void writeIndent() {
        if (this.level == 0 || this.level == -1) {
            return;
        }
        int totalIndent = this.level * 4;
        for (int i = 0; i < totalIndent; ++i) {
            this.write(' ');
        }
    }

    public final void writeNewLine() {
        if (this.level == -1) {
            this.write(' ');
        } else {
            this.write('\n');
        }
    }

    public final void writeNewLineAndIndent() {
        this.writeNewLine();
        this.writeIndent();
    }
}

