/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

import java.util.Objects;
import org.torqlang.util.Logger;
import org.torqlang.util.LoggerTools;
import org.torqlang.util.Message;

record MessageImpl(String name, String type, String message, String details, String internalId) implements Message
{
    MessageImpl {
        Objects.requireNonNull(name);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MessageImpl that = (MessageImpl)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type, this.message);
    }

    @Override
    public final void log(Logger logger) {
        String text = LoggerTools.formatter().apply(this.type, null, this.message);
        logger.log(text);
    }
}

