/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

import java.util.List;
import java.util.Objects;
import org.torqlang.util.FileName;
import org.torqlang.util.ListTools;
import org.torqlang.util.ResourceFileBroker;
import org.torqlang.util.SourceFile;

public final class ResourceFile
implements SourceFile {
    private final ResourceFileBroker broker;
    private final List<FileName> path;
    private final String content;

    public ResourceFile(ResourceFileBroker broker, List<FileName> path, String content) {
        this.broker = broker;
        this.path = ListTools.nullSafeCopyOf(path);
        this.content = content;
    }

    @Override
    public final ResourceFileBroker broker() {
        return this.broker;
    }

    @Override
    public final char charAt(int index) {
        return this.content.charAt(index);
    }

    @Override
    public final boolean containsIndex(int index) {
        return index > -1 && index < this.content.length();
    }

    @Override
    public final String content() {
        return this.content;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResourceFile that = (ResourceFile)other;
        return Objects.equals(this.broker(), that.broker()) && Objects.equals(this.path(), that.path()) && Objects.equals(this.content(), that.content());
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.path, this.content());
    }

    @Override
    public final boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public final List<FileName> path() {
        return this.path;
    }

    @Override
    public final String substring(int beginIndex, int endIndex) {
        return this.content.substring(beginIndex, endIndex);
    }
}

