/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.torqlang.util.FileName;
import org.torqlang.util.ListTools;
import org.torqlang.util.ReadTextFromResource;
import org.torqlang.util.ResourceFile;
import org.torqlang.util.SourceFileBroker;

public final class ResourceFileBroker
implements SourceFileBroker {
    private final Class<?> reference;
    private final List<List<FileName>> roots;
    private final List<Entry> content;

    public ResourceFileBroker(Class<?> reference, List<List<FileName>> roots, List<Entry> content) {
        this.reference = reference;
        this.roots = SourceFileBroker.checkForDuplicates(ListTools.nullSafeCopyOf(roots.stream().map(ListTools::nullSafeCopyOf).toList()));
        this.content = content;
    }

    public final List<Entry> content() {
        return this.content;
    }

    @Override
    public final List<FileName> list(List<FileName> absolutePath) {
        List<Entry> content = this.content();
        for (FileName fileName : absolutePath) {
            boolean found = false;
            for (Entry entry : content) {
                if (!fileName.value().equals(entry.name.value())) continue;
                found = true;
                content = entry.children;
                break;
            }
            if (found) continue;
            content = null;
            break;
        }
        if (content != null) {
            return ListTools.nullSafeCopyOf(content.stream().map(e -> e.name).toList());
        }
        return null;
    }

    @Override
    public final List<List<FileName>> roots() {
        return this.roots;
    }

    @Override
    public final ResourceFile source(List<FileName> path) throws IOException {
        String absolutePath = "/" + path.stream().map(FileName::value).collect(Collectors.joining("/"));
        String content = ReadTextFromResource.apply(this.reference, absolutePath);
        return new ResourceFile(this, path, content);
    }

    public record Entry(FileName name, List<Entry> children) {
    }
}

