/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

public interface Result<V, E> {
    public static <V, E> Result<V, E> error(E left) {
        return new Error(left);
    }

    public static <V, E> Result<V, E> value(V right) {
        return new Value(right);
    }

    public E error();

    public V value();

    public boolean isError();

    public boolean isValue();

    public static final class Error<V, E>
    implements Result<V, E> {
        private final E error;

        public Error(E error) {
            this.error = error;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        public boolean isValue() {
            return false;
        }

        @Override
        public E error() {
            return this.error;
        }

        @Override
        public V value() {
            return null;
        }
    }

    public static final class Value<V, E>
    implements Result<V, E> {
        private final V value;

        public Value(V value) {
            this.value = value;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public E error() {
            return null;
        }

        @Override
        public V value() {
            return this.value;
        }
    }
}

