/*
 * Decompiled with CFR 0.152.
 */
package org.torqlang.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.torqlang.util.FileName;
import org.torqlang.util.FileType;
import org.torqlang.util.ListTools;
import org.torqlang.util.SourceFile;

public interface SourceFileBroker {
    public static List<FileName> append(List<FileName> path, FileName fileName) {
        if (!path.isEmpty() && !ListTools.last(path).type().equals((Object)FileType.FOLDER)) {
            throw new IllegalArgumentException("Not a path");
        }
        ArrayList<FileName> answer = new ArrayList<FileName>(path);
        answer.add(fileName);
        return List.of(answer.toArray(new FileName[0]));
    }

    public static List<List<FileName>> checkForDuplicates(List<List<FileName>> roots) {
        for (int i = 0; i < roots.size(); ++i) {
            List<FileName> left = roots.get(i);
            for (int j = i + 1; j < roots.size(); ++j) {
                List<FileName> right = roots.get(j);
                if (left.size() != right.size()) continue;
                boolean same = true;
                for (int k = 0; k < left.size(); ++k) {
                    if (left.get(k).value().equals(right.get(k).value())) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                throw new IllegalArgumentException("Duplicate root path");
            }
        }
        return roots;
    }

    public static boolean hasRoot(List<FileName> path, List<FileName> root) {
        if (root.size() > path.size()) {
            return false;
        }
        for (int i = 0; i < root.size(); ++i) {
            if (root.get(i).equals(path.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<FileName> list(List<FileName> var1);

    public List<List<FileName>> roots();

    public SourceFile source(List<FileName> var1) throws IOException;

    default public List<FileName> trimRoot(List<FileName> absolutePath) {
        for (List<FileName> root : this.roots()) {
            if (!SourceFileBroker.hasRoot(absolutePath, root)) continue;
            return absolutePath.subList(root.size(), absolutePath.size());
        }
        return null;
    }
}

